/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.step;

import de.anormalmedia.sbstutorial.SBSTutorial;
import de.anormalmedia.sbstutorial.Tutorial;
import de.anormalmedia.sbstutorial.gui.ComponentFinder;
import de.anormalmedia.sbstutorial.gui.step.Step;
import de.anormalmedia.sbstutorial.listener.EventTutorialListener;
import de.anormalmedia.sbstutorial.listener.StepChangedListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class TutorialStepFrame
extends JDialog
implements StepChangedListener {
    private static final long serialVersionUID = 1L;
    private JTextPane tp;
    private final EventTutorialListener eventTutorialListener;
    private final Tutorial tutorial;
    private JButton btRestart;
    private JButton btHelp;
    private JButton btStop;
    private JButton btStart;
    private ResourceBundle languageResource;
    private Step lastExecutedStep;
    private JPanel restarthint;
    private JPanel centercontent;
    private boolean isStarted = false;

    public TutorialStepFrame(Tutorial tutorial, EventTutorialListener eventTutorialListener, Frame parent, JTextPane textpane) {
        super(parent);
        this.tp = textpane;
        this.tutorial = tutorial;
        this.eventTutorialListener = eventTutorialListener;
        this.prepareGui(tutorial, parent);
    }

    public TutorialStepFrame(Tutorial tutorial, EventTutorialListener eventTutorialListener, Dialog parent, JTextPane textpane) {
        super(parent);
        this.tp = textpane;
        this.tutorial = tutorial;
        this.eventTutorialListener = eventTutorialListener;
        this.prepareGui(tutorial, parent);
    }

    public TutorialStepFrame(Tutorial tutorial, EventTutorialListener eventTutorialListener, Window parent, JTextPane textpane) {
        this.tp = textpane;
        this.tutorial = tutorial;
        this.eventTutorialListener = eventTutorialListener;
        this.prepareGui(tutorial, parent);
    }

    private void prepareGui(Tutorial tutorial, Window parent) {
        this.languageResource = ResourceBundle.getBundle("de.anormalmedia.sbstutorial.i18n.TutorialStepFrame");
        this.setTitle(this.getLabelText("gui.frame.title"));
        this.setName("de.anormalmedia.sbstutorial.TutorialStepFrame");
        this.setDefaultCloseOperation(2);
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        content.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        content.getActionMap().put("cancel", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                TutorialStepFrame.this.dispose();
            }
        });
        this.centercontent = new JPanel(new BorderLayout());
        content.add((Component)this.centercontent, "Center");
        this.restarthint = new JPanel(new BorderLayout());
        this.centercontent.add((Component)this.restarthint, "South");
        JLabel restartlabel = new JLabel(this.getLabelText("gui.frame.restartmsg"));
        this.restarthint.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.restarthint.add((Component)restartlabel, "Center");
        this.restarthint.setVisible(false);
        this.tp.setContentType("text/html");
        this.centercontent.add((Component)new JScrollPane(this.tp), "Center");
        JPanel buttons = new JPanel(new FlowLayout());
        content.add((Component)buttons, "South");
        this.btStart = new JButton(this.getLabelText("gui.button.start"));
        this.btStart.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                TutorialStepFrame.this.tutorial.nextStep();
            }
        });
        this.btStart.setVisible(true);
        buttons.add(this.btStart);
        this.btRestart = new JButton(this.getLabelText("gui.button.restart"));
        this.btRestart.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                TutorialStepFrame.this.eventTutorialListener.restart();
            }
        });
        this.btRestart.setVisible(false);
        buttons.add(this.btRestart);
        this.btHelp = new JButton(this.getLabelText("gui.button.help"));
        this.btHelp.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                final JDialog helpdialog = new JDialog((Dialog)TutorialStepFrame.this, TutorialStepFrame.this.getLabelText("gui.button.help"));
                helpdialog.setModal(true);
                JPanel helpcontent = (JPanel)helpdialog.getContentPane();
                helpcontent.setLayout(new BorderLayout());
                helpcontent.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelhelp");
                helpcontent.getActionMap().put("cancelhelp", new AbstractAction(){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent e) {
                        helpdialog.dispose();
                    }
                });
                JTextPane tp = new JTextPane();
                tp.setContentType("text/html");
                tp.setText(TutorialStepFrame.this.getLabelText("gui.help"));
                tp.setEditable(false);
                tp.setCaretPosition(0);
                helpcontent.add((Component)new JScrollPane(tp), "Center");
                helpdialog.setSize(300, 300);
                helpdialog.setLocationRelativeTo(TutorialStepFrame.this);
                helpdialog.setVisible(true);
            }
        });
        buttons.add(this.btHelp);
        this.btStop = new JButton(this.getLabelText("gui.button.exit"));
        this.btStop.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                TutorialStepFrame.this.dispose();
            }
        });
        buttons.add(this.btStop);
        JLabel titLabel = new JLabel(tutorial.getTitle());
        titLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        content.add((Component)titLabel, "North");
        int maxwidth = (int)((double)tutorial.getInitialSize().width * 0.8);
        Font initialFont = titLabel.getFont().deriveFont(1);
        boolean fontfound = false;
        FontRenderContext frc = new FontRenderContext(null, true, false);
        int counter = 0;
        while (!fontfound && initialFont.getSize() < 16) {
            Font deriveFont = initialFont.deriveFont((float)(initialFont.getSize() + 1));
            int stringWidth = (int)deriveFont.getStringBounds(tutorial.getTitle(), frc).getWidth();
            if (stringWidth > maxwidth) {
                fontfound = true;
            }
            initialFont = deriveFont;
            if (++counter <= 20) continue;
            fontfound = true;
        }
        titLabel.setFont(initialFont);
        this.isStarted = false;
        if (this.hasModalWindows()) {
            this.btStart.setEnabled(false);
            this.btRestart.setEnabled(false);
            this.btHelp.setEnabled(false);
            this.btStop.setEnabled(false);
            this.tp.setText(this.getLabelText("gui.frame.modaldialogs"));
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    WindowEvent we;
                    if (event instanceof WindowEvent && (we = (WindowEvent)event).getID() == 202 && !TutorialStepFrame.this.hasModalWindows()) {
                        TutorialStepFrame.this.isStarted = true;
                        TutorialStepFrame.this.stepChanged(TutorialStepFrame.this.tutorial.getCurrentStep());
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        TutorialStepFrame.this.btStart.setEnabled(true);
                        TutorialStepFrame.this.btRestart.setEnabled(true);
                        TutorialStepFrame.this.btHelp.setEnabled(true);
                        TutorialStepFrame.this.btStop.setEnabled(true);
                    }
                }
            }, 64L);
        } else {
            this.isStarted = true;
        }
        this.setAlwaysOnTop(false);
        this.setPreferredSize(tutorial.getInitialSize());
        this.setSize(tutorial.getInitialSize());
        if (parent != null && parent.isShowing()) {
            Point locOnScreen = parent.getLocationOnScreen();
            Dimension psize = parent.getSize();
            int locx = locOnScreen.x;
            Insets margin = tutorial.getMargin();
            if (tutorial.getLochoriz() != null) {
                locx = tutorial.getLochoriz().equalsIgnoreCase("right") ? (locx += psize.width - this.getSize().width - margin.right) : (tutorial.getLochoriz().equalsIgnoreCase("center") ? (locx += psize.width / 2 - this.getSize().width / 2) : locOnScreen.x + margin.left);
            }
            int locy = locOnScreen.y;
            if (tutorial.getLocvert() != null) {
                locy = tutorial.getLocvert().equalsIgnoreCase("bottom") ? (locy += psize.height - this.getSize().height - margin.bottom) : (tutorial.getLochoriz().equalsIgnoreCase("middle") ? (locy += psize.height / 2 - this.getSize().height / 2) : locOnScreen.y + margin.top);
            }
            this.setLocation(locx, locy);
        }
        this.setVisible(true);
    }

    private boolean hasModalWindows() {
        ArrayList<Window> allWindows = ComponentFinder.getAllWindows();
        if (allWindows != null) {
            for (Window wind : allWindows) {
                Dialog dlg;
                if (!(wind instanceof Dialog) || !(dlg = (Dialog)wind).isModal() || !dlg.isVisible()) continue;
                return true;
            }
        }
        return false;
    }

    public Tutorial getTutorial() {
        return this.tutorial;
    }

    public void dispose() {
        this.eventTutorialListener.stopListener();
        this.tutorial.stop();
        SBSTutorial.removeTutorialFrame(this);
        super.dispose();
    }

    public void stepChanged(Step currentStep) {
        if (!this.isStarted && this.hasModalWindows()) {
            return;
        }
        if (currentStep != null) {
            this.restarthint.setVisible(currentStep == this.lastExecutedStep);
            String description = currentStep.getDescription();
            String baseURL = this.tutorial.getStore().getUrl().toString().substring(0, this.tutorial.getStore().getUrl().toString().lastIndexOf(47) + 1);
            description = description.replace("<head>", "<head><base href=\"" + baseURL + "\" />");
            this.tp.setText(description);
            if (currentStep.getType() == 1) {
                this.btStart.setVisible(true);
                this.btRestart.setVisible(false);
            } else if (currentStep.getType() == 0) {
                this.btStart.setVisible(false);
                this.btRestart.setVisible(true);
            } else if (currentStep.getType() == 2) {
                this.btStart.setVisible(false);
                this.btRestart.setVisible(true);
            }
            this.centercontent.validate();
        }
        this.lastExecutedStep = currentStep;
    }

    private String getLabelText(String key) {
        if (this.languageResource == null) {
            return key;
        }
        String value = this.languageResource.getString(key);
        if (value == null) {
            return key;
        }
        return value;
    }
}

