/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.recorder;

import de.anormalmedia.sbstutorial.gui.recorder.XMLPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ResourcePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final XMLPanel xmlpanel;
    private JList mlist;

    public ResourcePane(XMLPanel xmlpanel) {
        super(new BorderLayout());
        this.xmlpanel = xmlpanel;
        this.mlist = new JList();
        this.mlist.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String selectedValue = ResourcePane.this.mlist.getSelectedValue().toString();
                    ResourcePane.this.xmlpanel.getTextArea().replaceSelection("");
                    ResourcePane.this.xmlpanel.insertString("$" + selectedValue.substring(0, selectedValue.indexOf(61)));
                }
            }
        });
        this.add((Component)new JScrollPane(this.mlist), "Center");
        xmlpanel.getTextArea().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                String selectedText = ResourcePane.this.xmlpanel.getTextArea().getSelectedText();
                ResourcePane.this.listProperties(ResourcePane.this.xmlpanel.getTextArea().getText(), selectedText);
            }
        });
    }

    private void listProperties(String text, String selection) {
        Vector<String> vector = new Vector<String>();
        Pattern pattern = Pattern.compile("<\\s*externallanguageresource\\s+file=\"([a-zA-Z0-9\\.]+)\"\\s*/>");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            try {
                String group = matcher.group(1);
                ResourceBundle bundle = ResourceBundle.getBundle(group);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String value = bundle.getString(key);
                    if (selection != null && !value.toLowerCase().contains(selection.toLowerCase()) && !key.toLowerCase().contains(selection.toLowerCase())) continue;
                    vector.add(String.valueOf(key) + "=" + value);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Collections.sort(vector);
        this.mlist.setListData(vector);
    }
}

