/*
 * Decompiled with CFR 0.152.
 */
package com.inet.designer.plugin.repository.drive;

import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.font.FontProvider;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.report.BaseUtils;
import com.inet.report.jsonrpc.AbstractJsonRpcPacketHandler;
import com.inet.report.jsonrpc.JsonRpcRequest;
import com.inet.report.jsonrpc.JsonRpcResult;
import com.inet.report.permissions.PermissionChecker;
import com.inet.report.plugins.json.repository.shared.FileDescription;
import com.inet.report.plugins.json.repository.shared.FolderDescription;
import com.inet.report.plugins.json.repository.shared.RepositoryMethods;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends AbstractJsonRpcPacketHandler {
    private static final JsonTypeResolver aUU = new JsonTypeResolver(){

        protected Type getGenericType(Object obj, Field field) {
            if (field.getDeclaringClass() == JsonRpcRequest.class && field.getName().endsWith("params")) {
                try {
                    return ArrayList.class;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return super.getGenericType(obj, field);
        }
    };

    public b() {
        super(aUU);
    }

    public String getCommand() {
        return "designer_drive";
    }

    protected JsonRpcResult handle(HttpServletRequest request, JsonRpcRequest packet) {
        RepositoryMethods repositoryMethods;
        boolean bl2;
        boolean bl3 = bl2 = UserManager.getInstance().getCurrentUserAccountID() != null && SystemPermissionChecker.checkSharedAccess((String)"interface_repository");
        if (!bl2) {
            throw new AccessDeniedException("Login required");
        }
        Drive drive = Drive.getInstance();
        if (drive == null) {
            return packet.error("No active drive on this server");
        }
        try {
            repositoryMethods = RepositoryMethods.valueOf(packet.getMethod());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return packet.error("Unknown method: " + packet.getMethod());
        }
        switch (repositoryMethods) {
            case Root: {
                @Nonnull DriveEntry driveEntry = drive.resolve("/");
                return packet.result((Object)b.a(null, driveEntry));
            }
            case Folders: {
                DriveEntry driveEntry = drive.resolve((String)packet.getParam(0));
                if (driveEntry == null) {
                    return packet.error("Folder does not exists: " + String.valueOf(packet.getParam(0)));
                }
                Folder folder = (Folder)driveEntry.getFeature(DriveEntry.FOLDER);
                ArrayList<FolderDescription> arrayList = new ArrayList<FolderDescription>();
                if (folder != null) {
                    List list = folder.getChildren();
                    for (DriveEntry driveEntry2 : list) {
                        if (!driveEntry2.hasFeature(DriveEntry.FOLDER)) continue;
                        arrayList.add(b.a(driveEntry, driveEntry2));
                    }
                }
                return packet.result(arrayList);
            }
            case Files: {
                DriveEntry driveEntry = drive.resolve((String)packet.getParam(0));
                if (driveEntry == null) {
                    return packet.error("Folder does not exists: " + String.valueOf(packet.getParam(0)));
                }
                Folder folder = (Folder)driveEntry.getFeature(DriveEntry.FOLDER);
                ArrayList<FileDescription> arrayList = new ArrayList<FileDescription>();
                if (folder != null) {
                    List list = folder.getChildren();
                    for (DriveEntry driveEntry3 : list) {
                        if (!driveEntry3.hasFeature(DriveEntry.CONTENT)) continue;
                        arrayList.add(b.b(driveEntry3));
                    }
                }
                return packet.result(arrayList);
            }
            case Delete: {
                DriveEntry driveEntry = b.b(drive, (String)packet.getParam(0));
                try {
                    driveEntry.delete(null);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    return packet.error(driveOperationConflictException.getMessage());
                }
                return packet.result((Object)(driveEntry != null && !driveEntry.exists() ? 1 : 0));
            }
            case Exists: {
                DriveEntry driveEntry = b.b(drive, (String)packet.getParam(0));
                return packet.result((Object)(driveEntry != null && driveEntry.exists() ? 1 : 0));
            }
            case Folder: 
            case File: 
            case CreateFile: 
            case CreateFolder: 
            case Rename: {
                return b.a(repositoryMethods, drive, packet);
            }
            case Thumbnail: {
                try {
                    byte[] byArray;
                    Thumbnail thumbnail;
                    DriveEntry driveEntry = b.b(drive, (String)packet.getParam(0));
                    if (driveEntry != null && (thumbnail = (Thumbnail)driveEntry.getFeature(DriveEntry.THUMBNAIL)) != null && (byArray = this.a(thumbnail, 0)) != null) {
                        return packet.result((Object)new String(byArray, 0));
                    }
                }
                catch (IOException iOException) {
                    BaseUtils.warning((Object)iOException);
                }
                return packet.result(null);
            }
            case Keywords: {
                String string;
                MetaData metaData;
                DriveEntry driveEntry = b.b(drive, (String)packet.getParam(0));
                if (driveEntry != null && (metaData = (MetaData)driveEntry.getFeature(DriveEntry.META_DATA)) != null && (string = (String)metaData.getMetaData(MetaData.KEYWORDS)) != null) {
                    return packet.result((Object)string.split(" "));
                }
                return packet.result(null);
            }
            case SetKeywords: {
                ArrayList arrayList = (ArrayList)packet.getParams();
                DriveEntry driveEntry = b.b(drive, (String)packet.getParam(0));
                if (driveEntry != null) {
                    arrayList.remove(0);
                    MetaData metaData = (MetaData)driveEntry.getFeature(DriveEntry.META_DATA);
                    if (metaData != null) {
                        try {
                            metaData.setMetaData(MetaData.KEYWORDS, (Object)String.join((CharSequence)" ", arrayList));
                        }
                        catch (Exception exception) {
                            BaseUtils.error((Object)exception);
                            return packet.error(StringFunctions.getUserFriendlyErrorMessage((Throwable)exception));
                        }
                    }
                    return packet.result((Object)Boolean.TRUE);
                }
                return packet.result((Object)Boolean.FALSE);
            }
            case Search: {
                try {
                    return packet.result(b.a(drive, (String)packet.getParam(0)));
                }
                catch (Exception exception) {
                    BaseUtils.error((Object)exception);
                    return packet.error(StringFunctions.getUserFriendlyErrorMessage((Throwable)exception));
                }
            }
            case ServerVersion: {
                return packet.result((Object)BaseUtils.getVersion());
            }
            case AvailableFonts: {
                return packet.result((Object)FontProvider.getInstance().getAvailableFonts());
            }
            case Save: {
                String string = (String)packet.getParam(0);
                DriveEntry driveEntry = b.b(drive, string);
                if (driveEntry == null) {
                    int n2 = string.lastIndexOf(47);
                    if (n2 >= 0) {
                        DriveEntry driveEntry4 = drive.resolve(string.substring(0, n2));
                        if (driveEntry4 != null) {
                            DataEntry dataEntry = new DataEntry(string.substring(n2 + 1), IOFunctions.getAsciiStream((String)((String)packet.getParam(1))));
                            try {
                                driveEntry = drive.createFile(string.substring(0, n2), dataEntry);
                            }
                            catch (DriveOperationConflictException driveOperationConflictException) {
                                BaseUtils.error((Object)((Object)driveOperationConflictException));
                                return packet.error(StringFunctions.getUserFriendlyErrorMessage((Throwable)driveOperationConflictException));
                            }
                        }
                    } else {
                        DriveEntry driveEntry5 = drive.resolve("Drive");
                        if (driveEntry5 != null) {
                            DataEntry dataEntry = new DataEntry(string, IOFunctions.getAsciiStream((String)((String)packet.getParam(1))));
                            try {
                                driveEntry = drive.createFile(null, dataEntry);
                            }
                            catch (DriveOperationConflictException driveOperationConflictException) {
                                BaseUtils.error((Object)((Object)driveOperationConflictException));
                                return packet.error(StringFunctions.getUserFriendlyErrorMessage((Throwable)driveOperationConflictException));
                            }
                        }
                    }
                    if (driveEntry == null) {
                        return packet.result((Object)Boolean.FALSE);
                    }
                    return packet.result((Object)Boolean.TRUE);
                }
                Content content = (Content)driveEntry.getFeature(DriveEntry.CONTENT);
                try {
                    content.setInputStream(IOFunctions.getAsciiStream((String)((String)packet.getParam(1))), null);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    BaseUtils.error((Object)((Object)driveOperationConflictException));
                    return packet.error(StringFunctions.getUserFriendlyErrorMessage((Throwable)driveOperationConflictException));
                }
                return packet.result((Object)Boolean.TRUE);
            }
            case Load: {
                DriveEntry driveEntry = b.b(drive, (String)packet.getParam(0));
                if (driveEntry == null) {
                    return packet.result(null);
                }
                try {
                    String string = "";
                    Content content = (Content)driveEntry.getFeature(DriveEntry.CONTENT);
                    if (content != null) {
                        try (InputStream inputStream = content.getInputStream();){
                            string = IOFunctions.readAsciiString((InputStream)inputStream);
                        }
                    }
                    return packet.result((Object)string);
                }
                catch (IOException iOException) {
                    BaseUtils.error((Object)iOException);
                    return packet.error(StringFunctions.getUserFriendlyErrorMessage((Throwable)iOException));
                }
            }
        }
        return packet.error("Unknown method: " + packet.getMethod());
    }

    private byte[] a(Thumbnail thumbnail, int n2) throws IOException {
        try (InputStream inputStream = thumbnail.getThumbnail(Thumbnail.Size.px512);){
            if (inputStream != null) {
                byte[] byArray = inputStream.readAllBytes();
                return byArray;
            }
        }
        if (n2 < 1) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.a(thumbnail, n2 + 1);
        }
        return null;
    }

    @Nonnull
    private static FolderDescription a(@Nullable DriveEntry driveEntry, @Nonnull DriveEntry driveEntry2) {
        String string = driveEntry2.getName();
        int n2 = 0;
        Permissions permissions = (Permissions)driveEntry2.getFeature(DriveEntry.PERMISSIONS);
        if (driveEntry == null || driveEntry.getParent() != null || string.toLowerCase().equals("users")) {
            // empty if block
        }
        int n3 = 0;
        if (permissions != null && permissions.hasPermission("EDITOR")) {
            n3 += 2;
        }
        if (permissions != null && permissions.hasPermission("VIEWER")) {
            n3 += 4;
        }
        return new FolderDescription(string, n3, n2);
    }

    private static List<String> a(Drive drive, String string) throws Exception {
        SearchCondition searchCondition = new SearchCondition(MetaData.NAME.getKey(), SearchCondition.SearchTermOperator.StartsWith, (Object)string);
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{searchCondition});
        SearchResult searchResult = drive.search(searchCommand);
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = searchResult.getEntries();
        for (SearchResultEntry searchResultEntry : list) {
            DriveEntry driveEntry = drive.resolve((String)searchResultEntry.getId());
            if (driveEntry == null) continue;
            arrayList.add(driveEntry.getPath());
        }
        return arrayList;
    }

    private static DriveEntry b(Drive drive, String string) {
        return drive.resolve(string);
    }

    private static JsonRpcResult a(RepositoryMethods repositoryMethods, Drive drive, JsonRpcRequest jsonRpcRequest) {
        DriveEntry driveEntry = b.b(drive, (String)jsonRpcRequest.getParam(0));
        if (driveEntry != null) {
            DriveEntry driveEntry2 = b.a(repositoryMethods, drive, driveEntry, (String)jsonRpcRequest.getParam(1));
            if (driveEntry2 != null && driveEntry2.hasFeature(DriveEntry.CONTENT)) {
                return jsonRpcRequest.result((Object)b.b(driveEntry2));
            }
            if (driveEntry2 != null && driveEntry2.hasFeature(DriveEntry.FOLDER)) {
                return jsonRpcRequest.result((Object)b.a(driveEntry, driveEntry2));
            }
        }
        return jsonRpcRequest.result(null);
    }

    private static DriveEntry a(RepositoryMethods repositoryMethods, Drive drive, DriveEntry driveEntry, String string) {
        Object object = driveEntry.getPath();
        if (((String)object).length() > 0 && !((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        switch (repositoryMethods) {
            case Folder: {
                DriveEntry driveEntry2 = drive.resolve((String)object + string);
                if (driveEntry2 != null && driveEntry2.hasFeature(DriveEntry.FOLDER)) {
                    return driveEntry2;
                }
                return null;
            }
            case File: {
                DriveEntry driveEntry3 = drive.resolve((String)object + string);
                if (driveEntry3 != null && driveEntry3.hasFeature(DriveEntry.CONTENT)) {
                    return driveEntry3;
                }
                return null;
            }
            case CreateFolder: {
                try {
                    return drive.createFolder((String)object, string);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    BaseUtils.error((Object)((Object)driveOperationConflictException));
                    return null;
                }
            }
            case CreateFile: {
                try {
                    return drive.createFile((String)object + string, new DataEntry(string, ""));
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    BaseUtils.error((Object)((Object)driveOperationConflictException));
                    return null;
                }
            }
            case Rename: {
                try {
                    ((MetaData)driveEntry.getFeature(MetaData.class)).setMetaData(MetaData.NAME, (Object)string);
                    return driveEntry;
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    BaseUtils.error((Object)((Object)driveOperationConflictException));
                    return null;
                }
            }
        }
        return null;
    }

    private static FileDescription b(DriveEntry driveEntry) {
        Number number;
        String string = driveEntry.getName();
        long l2 = 0L;
        MetaData metaData = (MetaData)driveEntry.getFeature(DriveEntry.META_DATA);
        if (metaData != null && (number = (Number)metaData.getMetaData(MetaData.SIZE)) != null) {
            l2 = number.longValue();
        }
        number = (Permissions)driveEntry.getFeature(DriveEntry.PERMISSIONS);
        int n2 = 0;
        if (number != null && number.hasPermission("EDITOR")) {
            n2 += 2;
        }
        if (number != null && number.hasPermission("VIEWER")) {
            n2 += 4;
        }
        if (SystemPermissionChecker.checkAccess((Permission)PermissionChecker.PERMISSION_EXECUTE_ALL_REPORTS) && (string.endsWith(".rpt") || string.endsWith(".dataview"))) {
            ++n2;
        }
        return new FileDescription(string, l2, driveEntry.getLastModified(), n2);
    }
}

