/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.widgets;

import com.inet.annotations.InternalApi;
import com.inet.swing.i18n.LibConstants;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
public class NumberField
extends JFormattedTextField {
    public static final int INTEGER_STYLE = 0;
    public static final int NUMBER_STYLE = 1;
    private Color ie = new Color(255, 179, 179);
    private Number if;
    private boolean ig;
    private Number ih;
    private boolean ii;
    private a ij;
    private Popup ik;

    public NumberField() {
        this(NumberFormat.getIntegerInstance());
    }

    public NumberField(int style) {
        this(style == 0 ? NumberFormat.getIntegerInstance() : NumberFormat.getNumberInstance());
    }

    public NumberField(NumberFormat format) {
        super(format);
        this.setFocusLostBehavior(0);
        this.setColumns(10);
        format.setGroupingUsed(false);
        this.ij = new a();
        this.addMouseListener(this.ij);
        this.addMouseMotionListener(this.ij);
        this.getDocument().addDocumentListener(this.ij);
        this.addFocusListener(this.ij);
    }

    private void update() {
        boolean bl = this.as();
        if (bl) {
            this.setBackground(this.isEnabled() ? UIManager.getColor("TextField.background") : UIManager.getColor("TextField.inactiveBackground"));
            this.hidePopup();
        } else {
            this.setBackground(this.ie);
            this.showPopup();
        }
    }

    private void showPopup() {
        if (this.if == null && this.ih == null || this.at() == null) {
            return;
        }
        if (this.ik != null) {
            return;
        }
        if (!(this.isDisplayable() && this.isShowing() && this.isFocusOwner())) {
            return;
        }
        JToolTip jToolTip = new JToolTip();
        jToolTip.setTipText(this.ar());
        Point point = this.getLocationOnScreen();
        this.ik = PopupFactory.getSharedInstance().getPopup(this, jToolTip, point.x, point.y + this.getHeight() + 2);
        this.ik.show();
    }

    private void hidePopup() {
        if (this.ik != null) {
            this.ik.hide();
            this.ik = null;
        }
    }

    public void setMinValue(Number minValue, boolean include) {
        this.if = minValue;
        this.ig = include;
    }

    public void setMaxValue(Number maxValue, boolean include) {
        this.ih = maxValue;
        this.ii = include;
    }

    private String ar() {
        Object object = null;
        if (this.if != null && this.ih != null) {
            char c2 = this.ig ? (char)'[' : ']';
            char c3 = this.ii ? (char)']' : '[';
            String string = "inet.lib.valuenotinrange";
            String string2 = "<b>" + c2 + this.b(this.if) + "</b>";
            String string3 = "<b>" + this.b(this.ih) + c3 + "</b>";
            object = LibConstants.MSG.getMsg(string, new Object[]{string2, string3});
        } else if (this.if != null) {
            String string = this.ig ? "inet.lib.notgreaterequal" : "inet.lib.notgreater";
            String string4 = "<b>" + this.b(this.if) + "</b>";
            object = LibConstants.MSG.getMsg(string, new Object[]{"", string4});
        } else if (this.ih != null) {
            String string = this.ii ? "inet.lib.notlowerequal" : "inet.lib.notlower";
            String string5 = "<b>" + this.b(this.ih) + "</b>";
            object = LibConstants.MSG.getMsg(string, new Object[]{"", string5});
        }
        return object == null ? object : "<html>" + object + "</html>";
    }

    private String b(Number number) {
        try {
            return this.getFormatter().valueToString(number);
        }
        catch (ParseException parseException) {
            return "";
        }
    }

    private boolean as() {
        Number number = this.at();
        if (number == null) {
            if (this.getText().trim().length() > 0) {
                return false;
            }
        } else {
            double d2 = number.doubleValue();
            if (this.if != null && (this.ig ? d2 < this.if.doubleValue() : d2 <= this.if.doubleValue())) {
                return false;
            }
            if (this.ih != null && (this.ii ? d2 > this.ih.doubleValue() : d2 >= this.ih.doubleValue())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        }
    }

    private Number at() {
        try {
            return (Number)this.getFormatter().stringToValue(this.getText());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Number getNumber() {
        if (this.as()) {
            try {
                return (Number)this.getFormatter().stringToValue(this.getText());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setNumber(Number value) {
        this.setValue(value);
    }

    public void setNumber(int value) {
        this.setNumber(new Integer(value));
    }

    public void setNumber(long value) {
        this.setNumber(new Long(value));
    }

    public void setNumber(float value) {
        this.setNumber(new Float(value));
    }

    public void setNumber(double value) {
        this.setNumber(new Double(value));
    }

    private class a
    extends MouseInputAdapter
    implements FocusListener,
    DocumentListener {
        private a() {
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            NumberField.this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            NumberField.this.update();
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            NumberField.this.hidePopup();
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (!NumberField.this.hasFocus()) {
                final int n2 = NumberField.this.getCaretPosition();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 >= 0 && n2 <= NumberField.this.getDocument().getLength()) {
                            NumberField.this.setCaretPosition(n2);
                        }
                    }
                });
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            NumberField.this.hidePopup();
        }
    }
}

