/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.configuration.util;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigurationManager;
import com.inet.logging.Logger;
import com.inet.logging.StaticLogger;
import com.inet.shared.utils.Version;
import com.inet.swing.configuration.view.CategoryViewImpl;
import com.inet.swing.image.ImageUtils;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

@InternalApi
public class GUIUtils {
    public static final I18nMessages MSG = new I18nMessages("com.inet.swing.configuration.i18n.ConfigMessages", CategoryViewImpl.class);
    private static final Hashtable<String, Icon> di = new Hashtable();
    public static final Logger LOGGER = new StaticLogger("Reporting");
    public static final double[] SIZE = new double[]{0.75, 1.25, 1.5, 1.75};
    public static final String TABLE_CELL_EDIT = "edit.png";
    public static final String TABLE_CELL_DELETE = "trash_16.png";
    public static final String TABLE_CELL_OK = "ok_16.png";
    public static final String TABLE_CELL_NOTOK = "notok_16.png";

    public static Icon getIcon(String name) {
        if (((String)name).isEmpty()) {
            return null;
        }
        Icon icon = di.get(name);
        if (icon == null) {
            name = "images/" + (String)name;
            try {
                BufferedImage bufferedImage = ImageUtils.getImage((String)name, GUIUtils.class);
                icon = GUIUtils.createMultiResolutionImage(bufferedImage);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (icon == null && (icon = ImageUtils.getImageIcon((String)name, GUIUtils.class)) == null) {
                return new ImageIcon();
            }
            di.put((String)name, icon);
        }
        return icon;
    }

    public static LayoutManager getDefaultTwoColumnLayout() {
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{0.33, -1.0}, {-2.0}});
        tableLayout.setHGap(10);
        tableLayout.setVGap(10);
        return tableLayout;
    }

    public static LayoutManager getDefaultSingleColumnLayout() {
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{-1.0}, {-2.0}});
        tableLayout.setHGap(10);
        tableLayout.setVGap(0);
        return tableLayout;
    }

    public static LayoutManager getInlineRendererLayout() {
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}});
        tableLayout.setHGap(10);
        tableLayout.setVGap(0);
        return tableLayout;
    }

    public static JScrollPane createScollPanel(JComponent component) {
        JScrollPane jScrollPane = new JScrollPane(component);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        jScrollPane.getHorizontalScrollBar().setBlockIncrement(100);
        return jScrollPane;
    }

    public static void formatLabels(ArrayList<JLabel> lblComponents) {
        int n2 = 0;
        for (JLabel jLabel : lblComponents) {
            n2 = Math.max(n2, jLabel.getPreferredSize().width);
        }
        for (JLabel jLabel : lblComponents) {
            jLabel.setPreferredSize(new Dimension(n2, jLabel.getPreferredSize().height));
            jLabel.setHorizontalAlignment(4);
        }
    }

    public static void applyBaseLine(JLabel label, Component cmp) {
        int n2 = label.getBaseline(label.getPreferredSize().width, label.getPreferredSize().height);
        if (n2 >= 0) {
            int n3 = cmp.getBaseline(cmp.getPreferredSize().width, cmp.getPreferredSize().height);
            if (n3 == -1) {
                JTextField jTextField = new JTextField("testString");
                n3 = jTextField.getBaseline(jTextField.getPreferredSize().width, jTextField.getPreferredSize().height);
            }
            label.setBorder(new EmptyBorder(n3 - n2, 0, 0, 0));
            label.setVerticalAlignment(1);
        }
    }

    public static Color getBackgroundColor(int value, Color bgColor) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), fArray);
        float f2 = fArray[2];
        f2 = value % 2 == 0 ? (f2 > 0.9f ? (f2 -= 0.05f) : (f2 += 0.05f)) : (f2 > 0.9f ? (f2 -= 0.1f) : (f2 += 0.1f));
        fArray[2] = f2;
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    public static Color getContrastColor(float diff, Color bgColor) {
        return GUIUtils.getContrastColor(diff, bgColor, null);
    }

    public static Color getContrastColor(float diff, Color bgColor, @Nullable Color fgColor) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), fArray);
        float f2 = fArray[2];
        if (fgColor == null) {
            f2 = f2 < diff ? (f2 += diff) : (f2 -= diff);
        } else {
            float[] fArray2 = new float[3];
            Color.RGBtoHSB(fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue(), fArray2);
            f2 = f2 < fArray2[2] ? (f2 += diff) : (f2 -= diff);
        }
        fArray[2] = f2;
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    public static String scopeToString(int scope, String systemUsername) {
        switch (scope) {
            case 1: {
                return MSG.getMsg("scopeSystem", new Object[0]);
            }
            case 2: {
                return MSG.getMsg("scopeUser", new Object[0]) + (String)(systemUsername == null ? "" : " (" + systemUsername + ")");
            }
            case 4: {
                return MSG.getMsg("scopeTemp", new Object[0]);
            }
        }
        return ConfigurationManager.getScopeName((int)scope);
    }

    public static void copyLabelAttributes(JLabel defaultLabel, JLabel target) {
        target.setBorder(defaultLabel.getBorder());
        target.setForeground(defaultLabel.getForeground());
        target.setBackground(defaultLabel.getBackground());
        target.setOpaque(defaultLabel.isOpaque());
        target.setFont(defaultLabel.getFont());
    }

    public static ImageIcon getIconForUrl(URL iconUrl) {
        ImageIcon imageIcon = ImageUtils.getImageIcon(iconUrl);
        if (imageIcon == null) {
            BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
            imageIcon = new ImageIcon(bufferedImage.getScaledInstance(32, 32, 2));
        }
        return imageIcon;
    }

    public static ImageIcon createMultiResolutionImage(String name, Class<?> base) {
        try {
            if (name != null && base != null) {
                return GUIUtils.createMultiResolutionImage(ImageUtils.getImage(name, base));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static ImageIcon createMultiResolutionImage(BufferedImage bufferedImage) {
        block5: {
            try {
                if (bufferedImage != null) {
                    ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
                    arrayList.add(bufferedImage);
                    double[] objectArray = SIZE;
                    int baseMultiResolutionImage = objectArray.length;
                    for (int i2 = 0; i2 < baseMultiResolutionImage; ++i2) {
                        double d2 = objectArray[i2];
                        BufferedImage bufferedImage2 = new BufferedImage((int)Math.ceil((double)bufferedImage.getWidth() * d2), (int)Math.ceil((double)bufferedImage.getHeight() * d2), 2);
                        Graphics2D graphics2D = bufferedImage2.createGraphics();
                        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                        graphics2D.drawImage(bufferedImage, 0, 0, (int)Math.ceil((double)bufferedImage.getWidth() * d2), (int)Math.ceil((double)bufferedImage.getHeight() * d2), null);
                        graphics2D.dispose();
                        arrayList.add(bufferedImage2);
                    }
                    Image[] imageArray = new Image[arrayList.size()];
                    for (baseMultiResolutionImage = 0; baseMultiResolutionImage < arrayList.size(); ++baseMultiResolutionImage) {
                        imageArray[baseMultiResolutionImage] = (Image)arrayList.get(baseMultiResolutionImage);
                    }
                    BaseMultiResolutionImage baseMultiResolutionImage2 = new BaseMultiResolutionImage(imageArray);
                    return new ImageIcon(baseMultiResolutionImage2);
                }
            }
            catch (Exception exception) {
                if (Version.getJavaVersion().getMajor() < 9) break block5;
                LOGGER.error((Throwable)exception);
            }
        }
        return null;
    }

    public static JPanel createWrapper(JComponent component) {
        return GUIUtils.createWrapper(component, 5, 10, 10, 10);
    }

    public static JPanel createWrapper(JComponent component, int margin) {
        return GUIUtils.createWrapper(component, margin, margin, margin, margin);
    }

    public static JPanel createWrapper(JComponent component, int top, int left, int bottom, int right) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        jPanel.add((Component)component, "Center");
        return jPanel;
    }

    public static Color calcColorDiff(Color startColor, Color endColor, float valuedif) {
        Color color = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = startColor.getRed() + (int)((float)(endColor.getRed() - startColor.getRed()) * valuedif);
        n3 = startColor.getBlue() + (int)((float)(endColor.getBlue() - startColor.getBlue()) * valuedif);
        n4 = startColor.getGreen() + (int)((float)(endColor.getGreen() - startColor.getGreen()) * valuedif);
        color = new Color(Math.max(Math.min(n2, 256), 0), Math.max(Math.min(n3, 256), 0), Math.max(Math.min(n4, 256), 0));
        return color;
    }
}

