/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.configuration.util;

import com.inet.annotations.InternalApi;
import com.inet.swing.configuration.util.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;

@InternalApi
public class FormattedTextBox
extends JPanel
implements ActionListener {
    private final a cN = new a();
    public static final String VALIDITY = "validity";
    public static final String VALUE_CHANGE = "valueChange";
    private final JTextComponent cO;
    private final JPopupMenu cP = new JPopupMenu();
    private Color cQ;
    private Border cR;
    private Color cS = new Color(255, 238, 238);
    private Color cT = new Color(166, 0, 0);
    private Border cU;
    private PropertyChangeSupport cV = new PropertyChangeSupport(this.cN);
    private boolean cW = false;
    private com.inet.swing.configuration.util.a cX;
    private Timer W = new Timer(500, this);
    private Format cY;
    private JScrollPane cZ;
    private HashSet<Integer> da;
    private Number db;
    private DocumentListener dc;

    public FormattedTextBox() {
        this((Format)null, false);
    }

    public FormattedTextBox(Format format, Number defaultNumber) {
        this(format, false);
        this.db = defaultNumber;
    }

    public FormattedTextBox(boolean multiLine) {
        this((Format)null, multiLine);
    }

    private FormattedTextBox(Format format, boolean multiLine) {
        this.cY = format;
        this.cO = this.a(format, multiLine);
        if (format != null) {
            if (format instanceof NumberFormat) {
                ((NumberFormat)format).setGroupingUsed(false);
            }
            this.setFormat(format);
        }
        this.l();
    }

    @Override
    public void setName(String name) {
        this.cO.setName(name);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.cO.setToolTipText(text);
    }

    public void setOrgBorder(Border orgBorder) {
        this.cR = orgBorder;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(enabled);
            this.cO.setEnabled(enabled);
            this.cV.firePropertyChange(VALUE_CHANGE, null, this.cO.getText());
        } else {
            this.addError(null);
            super.setEnabled(enabled);
            this.cO.setEnabled(enabled);
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        int n2 = this.cO.getBaseline(width, height);
        if (this.cZ != null) {
            Insets insets;
            if (this.cZ.getBorder() != null && (insets = this.cZ.getBorder().getBorderInsets(this.cZ)) != null) {
                n2 += insets.top;
            }
            if (this.cZ.getViewportBorder() != null && (insets = this.cZ.getViewportBorder().getBorderInsets(this.cZ)) != null) {
                n2 += insets.top;
            }
        }
        return n2;
    }

    private JTextComponent a(Format format, boolean bl) {
        if (!bl) {
            JFormattedTextField jFormattedTextField = new JFormattedTextField(){

                @Override
                protected void fireActionPerformed() {
                    FormattedTextBox.this.getValidity();
                    super.fireActionPerformed();
                }

                @Override
                public void setText(String t) {
                    super.setText(t);
                }

                @Override
                protected boolean processKeyBinding(KeyStroke ks, KeyEvent e2, int condition, boolean pressed) {
                    if (e2.getKeyCode() == 27) {
                        return false;
                    }
                    return super.processKeyBinding(ks, e2, condition, pressed);
                }

                @Override
                public void setValue(Object value) {
                    Caret caret = this.getCaret();
                    int n2 = caret == null ? 0 : caret.getDot();
                    int n3 = caret == null ? 0 : this.getCaret().getMark();
                    super.setValue(value);
                    if (value == null) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        Caret caret = this.getCaret();
                        if (caret != null) {
                            caret.setDot(n3);
                            caret.moveDot(n2);
                        }
                    });
                }
            };
            jFormattedTextField.setColumns(10);
            jFormattedTextField.setFocusLostBehavior(0);
            return jFormattedTextField;
        }
        return new JTextArea(3, 10);
    }

    private void l() {
        Object object;
        this.setOpaque(false);
        this.cR = this.cO.getBorder();
        this.cQ = this.cO.getBackground();
        Insets insets = this.cR.getBorderInsets(this.cO);
        this.cU = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.cT), BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        if (this.cO instanceof JTextArea) {
            object = (JTextArea)this.cO;
            this.cZ = new JScrollPane((Component)object);
            this.add((Component)this.cZ, "Center");
        } else {
            this.add((Component)this.cO, "Center");
        }
        this.W.setRepeats(false);
        this.cO.getDocument().addDocumentListener(new b());
        this.cP.setFocusable(false);
        this.cP.setOpaque(false);
        this.cP.setUI(new BasicPopupMenuUI(){

            @Override
            public void installUI(JComponent c2) {
                super.installUI(c2);
            }

            @Override
            public Popup getPopup(JPopupMenu popup, int x, int y) {
                Popup popup2 = super.getPopup(popup, x, y);
                JPanel jPanel = (JPanel)popup.getParent();
                jPanel.setName("ValidationPopup.Panel");
                jPanel.setOpaque(false);
                return popup2;
            }
        });
        this.cP.setBackground(this.cS);
        this.cP.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, this.cT));
        this.addChangeListener(this.cN);
        this.cO.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if (!FormattedTextBox.this.cO.hasFocus()) {
                    final int n2 = FormattedTextBox.this.cO.getCaretPosition();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (n2 < 0) {
                                FormattedTextBox.this.cO.setCaretPosition(0);
                            } else if (n2 > FormattedTextBox.this.cO.getDocument().getLength()) {
                                FormattedTextBox.this.cO.setCaretPosition(FormattedTextBox.this.cO.getDocument().getLength());
                            } else {
                                FormattedTextBox.this.cO.setCaretPosition(n2);
                            }
                        }
                    });
                }
            }
        });
        this.cO.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                if (FormattedTextBox.this.cY == null) {
                    FormattedTextBox.this.cO.setText(FormattedTextBox.this.cO.getText());
                }
            }

            @Override
            public void focusLost(FocusEvent e2) {
                FormattedTextBox.this.W.stop();
                FormattedTextBox.this.cV.firePropertyChange(FormattedTextBox.VALUE_CHANGE, null, FormattedTextBox.this.cO.getText());
                FormattedTextBox.this.cO.firePropertyChange(FormattedTextBox.VALUE_CHANGE, false, true);
            }
        });
        this.cO.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e2) {
                FormattedTextBox.this.J();
            }

            @Override
            public void componentResized(ComponentEvent e2) {
                FormattedTextBox.this.J();
            }

            @Override
            public void componentShown(ComponentEvent e2) {
                FormattedTextBox.this.J();
            }
        });
        object = new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e2) {
                FormattedTextBox.this.J();
            }

            @Override
            public void componentResized(ComponentEvent e2) {
                FormattedTextBox.this.J();
            }

            @Override
            public void componentMoved(ComponentEvent e2) {
                FormattedTextBox.this.J();
            }

            @Override
            public void componentHidden(ComponentEvent e2) {
                FormattedTextBox.this.J();
            }
        };
        this.addComponentListener((ComponentListener)object);
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ComponentListener dh;
            {
                this.dh = componentListener;
            }

            @Override
            public void run() {
                Window window = SwingUtilities.windowForComponent(FormattedTextBox.this.cO);
                if (window != null) {
                    window.addComponentListener(this.dh);
                }
            }
        });
    }

    public void setFormat(Format format) {
        if (this.cO instanceof JFormattedTextField) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.cO;
            final DocumentFilter documentFilter = new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    super.insertString(fb, offset, this.o(string), attr);
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    super.replace(fb, offset, length, this.o(text), attrs);
                }

                private String o(String string) {
                    if (FormattedTextBox.this.da == null || string == null) {
                        return string;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (char c2 : string.toCharArray()) {
                        if (!FormattedTextBox.this.da.contains(c2)) continue;
                        stringBuilder.append(c2);
                    }
                    return stringBuilder.toString();
                }
            };
            if (format instanceof DateFormat) {
                jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new DateFormatter((DateFormat)format){

                    @Override
                    protected DocumentFilter getDocumentFilter() {
                        return documentFilter;
                    }
                }));
            } else if (format instanceof NumberFormat) {
                jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter((NumberFormat)format){

                    @Override
                    protected DocumentFilter getDocumentFilter() {
                        return documentFilter;
                    }
                }));
            } else if (format != null) {
                jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new InternationalFormatter(format){

                    @Override
                    protected DocumentFilter getDocumentFilter() {
                        return documentFilter;
                    }
                }));
            }
        }
        this.H();
    }

    private void H() {
        if (this.cO instanceof JFormattedTextField) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.cO;
            JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
            if (abstractFormatter instanceof NumberFormatter) {
                NumberFormatter numberFormatter = (NumberFormatter)abstractFormatter;
                Format format = numberFormatter.getFormat();
                if (format instanceof NumberFormat) {
                    this.da = new HashSet();
                    if (format instanceof DecimalFormat) {
                        char[] cArray;
                        DecimalFormat decimalFormat = (DecimalFormat)format;
                        for (char c2 : cArray = decimalFormat.toPattern().toCharArray()) {
                            if ('0' == c2 || '#' == c2) {
                                this.b(true);
                                continue;
                            }
                            if ('.' == c2) {
                                this.da.add(46);
                                this.da.add(44);
                                continue;
                            }
                            this.da.add(Integer.valueOf(c2));
                        }
                    } else {
                        this.b(true);
                    }
                }
            } else if (abstractFormatter instanceof DateFormatter) {
                DateFormatter dateFormatter = (DateFormatter)abstractFormatter;
                Format format = dateFormatter.getFormat();
                if (format instanceof SimpleDateFormat) {
                    char[] cArray;
                    SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
                    for (char c3 : cArray = simpleDateFormat.toPattern().toCharArray()) {
                        if ('G' == c3 || 'E' == c3 || 'c' == c3 || 'a' == c3 || 'z' == c3 || 'v' == c3) {
                            this.I();
                            continue;
                        }
                        if ('y' == c3 || 'd' == c3 || 'h' == c3 || 'H' == c3 || 'm' == c3 || 's' == c3 || 'S' == c3 || 'k' == c3 || 'K' == c3) {
                            this.b(false);
                            continue;
                        }
                        if ('L' == c3 || 'M' == c3) {
                            this.I();
                            this.b(false);
                            continue;
                        }
                        if ('Z' == c3) {
                            this.I();
                            this.b(true);
                            continue;
                        }
                        this.da.add(Integer.valueOf(c3));
                    }
                } else {
                    this.I();
                    this.b(true);
                }
            }
        }
    }

    private void b(boolean bl) {
        for (int i2 = 48; i2 <= 57; ++i2) {
            this.da.add(i2);
        }
        if (bl) {
            this.da.add(45);
        }
    }

    private void I() {
        int n2;
        for (n2 = 65; n2 <= 90; ++n2) {
            this.da.add(n2);
        }
        for (n2 = 97; n2 <= 122; ++n2) {
            this.da.add(n2);
        }
    }

    public void setText(String t) {
        this.cO.setText(t);
    }

    public String getText() {
        return this.cO.getText();
    }

    public void setValue(Object value) {
        if (this.cO instanceof JFormattedTextField) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.cO;
            jFormattedTextField.setValue(value);
        }
    }

    public void fireChangeUpdateEvent() {
        if (this.dc != null) {
            this.dc.changedUpdate(null);
        }
    }

    public Object getValue() {
        JFormattedTextField jFormattedTextField;
        String string;
        if (this.cO instanceof JFormattedTextField && (string = (jFormattedTextField = (JFormattedTextField)this.cO).getText()) != null && !string.isEmpty()) {
            try {
                jFormattedTextField.commitEdit();
                return jFormattedTextField.getValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public void addActionListener(ActionListener l2) {
        if (this.cO instanceof JFormattedTextField) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)this.cO;
            jFormattedTextField.addActionListener(l2);
        }
    }

    @Override
    public void addFocusListener(FocusListener l2) {
        this.cO.addFocusListener(l2);
    }

    @Override
    public void addKeyListener(KeyListener l2) {
        this.cO.addKeyListener(l2);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l2) {
        if (this.cO != null) {
            this.cO.addPropertyChangeListener(l2);
            return;
        }
        super.addPropertyChangeListener(l2);
    }

    @Override
    public void addPropertyChangeListener(String k2, PropertyChangeListener l2) {
        if (this.cO != null) {
            this.cO.addPropertyChangeListener(k2, l2);
            return;
        }
        super.addPropertyChangeListener(k2, l2);
    }

    public void addDocumentListener(DocumentListener l2) {
        this.dc = l2;
        this.cO.getDocument().addDocumentListener(l2);
    }

    public synchronized void addError(String errorMsg) {
        this.hidePopup();
        this.cP.removeAll();
        if (errorMsg != null) {
            JLabel jLabel = new JLabel(errorMsg){
                {
                    this.setBackground(FormattedTextBox.this.cS);
                    this.setOpaque(true);
                }
            };
            if (this.cO.isEnabled()) {
                jLabel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
                this.cP.add(jLabel);
                this.cO.setBackground(this.cS);
                this.cO.setBorder(this.cU);
                this.showPopup();
            }
        } else if (this.cO.isEnabled()) {
            this.cO.setBackground(this.cQ);
            this.cO.setBorder(this.cR);
        }
    }

    public void setValidator(com.inet.swing.configuration.util.a validator) {
        this.cX = validator;
    }

    public boolean getValidity() {
        return this.m(this.cO.getText());
    }

    private boolean m(String string) {
        String string2 = this.n(string);
        this.addError(string2);
        boolean bl = string2 == null;
        return bl;
    }

    public synchronized void showPopup() {
        if (this.isShowing() && !this.cP.isVisible()) {
            this.J();
            this.cP.setVisible(true);
        }
    }

    private void J() {
        if (!this.isShowing()) {
            this.hidePopup();
            return;
        }
        Point point = this.getLocationOnScreen();
        this.cP.setLocation(point.x, point.y + this.getHeight());
    }

    public void hidePopup() {
        if (this.cP.isVisible()) {
            this.cP.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.cV.firePropertyChange(VALUE_CHANGE, null, this.cO.getText());
    }

    public void addChangeListener(PropertyChangeListener pcl1) {
        this.cV.addPropertyChangeListener(pcl1);
        this.cV.firePropertyChange(VALIDITY, null, (Object)this.getValidity());
    }

    public void removeChangeListener(PropertyChangeListener pcl1) {
        this.cV.removePropertyChangeListener(pcl1);
    }

    public void setInsertSilent(boolean insertSilent) {
        this.cW = insertSilent;
    }

    @Override
    public boolean isFocusOwner() {
        return this.cO.isFocusOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String n(String string) {
        Object object;
        if (this.cX != null) {
            String string2 = string;
            if (this.cY instanceof NumberFormat) {
                object = (NumberFormat)this.cY;
                try {
                    string2 = ((NumberFormat)object).parse(string).toString();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if ((object = this.cX.p(string2)) != null) {
                return object;
            }
        }
        if (string == null || string.isEmpty()) {
            boolean bl;
            boolean bl2 = bl = this.db == null || this.db.toString().isEmpty();
            if (!bl) {
                return GUIUtils.MSG.getMsg("error.notset.default", new Object[]{this.db});
            }
        }
        if (this.cY != null) {
            try {
                Serializable serializable = null;
                this.cW = true;
                if (string != null && !string.isEmpty()) {
                    if (this.cY instanceof NumberFormat) {
                        serializable = ((NumberFormat)this.cY).parse(string);
                    } else if (this.cY instanceof DateFormat) {
                        serializable = ((DateFormat)this.cY).parse(string);
                    }
                } else if (this.cO instanceof JFormattedTextField) {
                    object = (JFormattedTextField)this.cO;
                    ((JFormattedTextField)object).setValue(null);
                }
            }
            catch (ParseException parseException) {
                object = parseException.getMessage();
                return object;
            }
            finally {
                this.cW = false;
            }
        }
        return null;
    }

    @Override
    public void requestFocus() {
        this.cO.requestFocus();
    }

    private class a
    implements PropertyChangeListener {
        private a() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (FormattedTextBox.VALUE_CHANGE.equals(evt.getPropertyName()) && evt.getNewValue() instanceof String) {
                if (!FormattedTextBox.this.cO.isFocusOwner()) {
                    FormattedTextBox.this.addError(null);
                    return;
                }
                String string = (String)evt.getNewValue();
                String string2 = FormattedTextBox.this.n(string);
                FormattedTextBox.this.addError(string2);
                if (string2 != null) {
                    FormattedTextBox.this.cV.firePropertyChange(FormattedTextBox.VALIDITY, null, Boolean.FALSE);
                } else {
                    FormattedTextBox.this.cV.firePropertyChange(FormattedTextBox.VALIDITY, null, Boolean.TRUE);
                }
            }
        }
    }

    private class b
    implements DocumentListener {
        private b() {
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            FormattedTextBox.this.hidePopup();
            FormattedTextBox.this.W.stop();
            if (!FormattedTextBox.this.cW) {
                FormattedTextBox.this.W.start();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            FormattedTextBox.this.hidePopup();
            FormattedTextBox.this.W.stop();
            if (!FormattedTextBox.this.cW) {
                FormattedTextBox.this.W.start();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
        }
    }
}

