/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.configuration.renderer;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.FileConfigProperty;
import com.inet.swing.configuration.renderer.Renderer;
import com.inet.swing.configuration.renderer.d;
import com.inet.swing.configuration.renderer.f;
import com.inet.swing.configuration.renderer.g;
import com.inet.swing.configuration.renderer.h;
import com.inet.swing.configuration.renderer.j;
import com.inet.swing.configuration.renderer.k;
import com.inet.swing.configuration.renderer.l;
import com.inet.swing.configuration.renderer.m;
import com.inet.swing.configuration.renderer.n;
import com.inet.swing.configuration.renderer.o;
import com.inet.swing.configuration.renderer.p;
import com.inet.swing.configuration.renderer.q;
import com.inet.swing.configuration.renderer.s;
import com.inet.swing.configuration.util.DataFactory;
import com.inet.swing.configuration.util.GUIUtils;
import com.inet.swing.configuration.view.ConfigurationFilter;
import java.util.HashMap;
import javax.annotation.Nonnull;

@InternalApi
public abstract class RendererFactory {
    private static HashMap<String, RendererFactory> bI = new HashMap();

    public abstract Renderer createRenderer(@Nonnull String var1, DataFactory var2, boolean var3);

    public static void addRenderer(String type, RendererFactory renderer) {
        bI.put(type, renderer);
    }

    public static Renderer get(ConfigurationFilter filter, ConfigProperty property, DataFactory dataFactory) {
        boolean bl = false;
        if (property.getType().startsWith("Table")) {
            bl = true;
        }
        switch (property.getType()) {
            case "Hidden": 
            case "Label": 
            case "Button": 
            case "ItemListlicensekey": {
                bl = true;
                break;
            }
            case "KeyLabel": 
            case "Boolean": {
                bl = property.getDisplayName() == null || property.getDisplayName().isEmpty();
                break;
            }
            case "TableDirectory": 
            case "TableClass": 
            case "TableSimpleText": {
                bl = false;
            }
        }
        return RendererFactory.a(filter, property, dataFactory, bl);
    }

    public static Renderer getInlineRenderer(ConfigProperty property, DataFactory dataFactory) {
        return RendererFactory.a(new ConfigurationFilter(), property, dataFactory, true);
    }

    private static Renderer a(ConfigurationFilter configurationFilter, ConfigProperty configProperty, DataFactory dataFactory, boolean bl) {
        String string = configProperty.getKey();
        if (configProperty.getType().startsWith("Table")) {
            return new p(string, dataFactory, bl);
        }
        RendererFactory rendererFactory = bI.get(configProperty.getType());
        if (rendererFactory != null) {
            return rendererFactory.createRenderer(string, dataFactory, bl);
        }
        if ("Hidden".equals(configProperty.getType())) {
            return new j(string, dataFactory);
        }
        if ("KeyLabel".equals(configProperty.getType())) {
            return new k(string, dataFactory);
        }
        if ("Label".equals(configProperty.getType())) {
            return new l(string, dataFactory);
        }
        if ("Password".equals(configProperty.getType())) {
            return new m(string, dataFactory);
        }
        if ("Boolean".equals(configProperty.getType())) {
            return new d(string, dataFactory);
        }
        if ("SimpleText".equals(configProperty.getType())) {
            return new q(string, dataFactory, bl);
        }
        if (("File".equals(configProperty.getType()) || "Directory".equals(configProperty.getType())) && configProperty instanceof FileConfigProperty) {
            return new f(string, dataFactory, (FileConfigProperty)configProperty, bl);
        }
        if ("File".equals(configProperty.getType())) {
            return new f(string, dataFactory, false, bl);
        }
        if ("Directory".equals(configProperty.getType())) {
            return new f(string, dataFactory, true, bl);
        }
        if (configProperty.getType().startsWith("Unit")) {
            if (configProperty.getType().contains("FixNumber")) {
                return new s(string, dataFactory, bl);
            }
            if (configProperty.getType().contains("FloatNumber")) {
                return new s(string, dataFactory, bl);
            }
        }
        if ("FixNumber".equals(configProperty.getType())) {
            return new g(string, dataFactory, bl);
        }
        if ("FloatNumber".equals(configProperty.getType())) {
            return new h(string, dataFactory, bl);
        }
        if (configProperty.getType().startsWith("Select")) {
            if (configProperty.getType().contains("SimpleText")) {
                return new o(string, dataFactory);
            }
            if (configProperty.getType().contains("FixNumber")) {
                return new o(string, dataFactory);
            }
            if ("SelectEdit".equals(configProperty.getType())) {
                return new n(string, dataFactory, bl);
            }
        }
        if (GUIUtils.LOGGER.isDebug()) {
            GUIUtils.LOGGER.debug((Object)("No renderer found for: " + configProperty.getKey() + ": " + configProperty.getClass().getName()));
        }
        return new q(string, dataFactory, bl);
    }
}

