/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing;

import com.inet.annotations.InternalApi;
import com.inet.swing.LaF;
import com.inet.swing.SwingFunctions;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

@InternalApi
public class ButtonFactory {
    private static MouseAdapter S = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent ev) {
            AbstractButton abstractButton = (AbstractButton)ev.getSource();
            if (abstractButton.isEnabled()) {
                abstractButton.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            AbstractButton abstractButton = (AbstractButton)ev.getSource();
            if (abstractButton instanceof JToggleButton && abstractButton.getModel().isSelected()) {
                return;
            }
            abstractButton.setBorderPainted(false);
        }
    };

    public static JToolBar createFixedToolBar(int orientation) {
        JToolBar jToolBar = new JToolBar(orientation){

            @Override
            public JButton add(Action a2) {
                return (JButton)super.add(ButtonFactory.createToggleButton(a2, null));
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        return jToolBar;
    }

    @Deprecated
    public static JButton createPlainButton() {
        return LaF.BUTTONFACTORY.createPlainButton();
    }

    @Deprecated
    public static JButton createPlainButton(Icon icon) {
        return LaF.BUTTONFACTORY.createPlainButton(icon);
    }

    @Deprecated
    public static JButton createPlainButton(Icon icon, String tooltip) {
        return LaF.BUTTONFACTORY.createPlainButton(icon, tooltip);
    }

    @Deprecated
    public static JButton createPlainButton(String text) {
        return LaF.BUTTONFACTORY.createPlainButton(text);
    }

    public static JButton createToolBarButton(Action action, String tooltip) {
        return ButtonFactory.a(LaF.BUTTONFACTORY.createPlainButton(action), tooltip);
    }

    public static JButton createToolBarTextButton(Action action, String tooltip) {
        return ButtonFactory.b(LaF.BUTTONFACTORY.createPlainButton(action), tooltip);
    }

    public static JButton createToolBarButton(String text, String tooltip) {
        return ButtonFactory.b(LaF.BUTTONFACTORY.createPlainButton(text), tooltip);
    }

    public static JButton createToolBarButton(Icon icon, String tooltip) {
        return ButtonFactory.a(LaF.BUTTONFACTORY.createPlainButton(icon), tooltip);
    }

    public static JButton createToolBarButton(Action action, String tooltip, Insets insets, int w, int h2) {
        return ButtonFactory.a(LaF.BUTTONFACTORY.createPlainButton(action), tooltip, insets, w, h2);
    }

    private static <T extends AbstractButton> T a(T t, String string) {
        return ButtonFactory.a(t, string, new Insets(2, 2, 2, 2), 26, 26);
    }

    private static <T extends AbstractButton> T a(T t, String string, Insets insets, int n2, int n3) {
        if (string != null && !string.isEmpty()) {
            t.setToolTipText(string);
        }
        if (insets != null) {
            t.setMargin(insets);
        }
        t.setHideActionText(true);
        SwingFunctions.setFixedSize(t, n2, n3);
        t.setOpaque(false);
        t.setBorderPainted(false);
        t.addMouseListener(S);
        return t;
    }

    private static <T extends AbstractButton> T b(T t, String string) {
        if (string != null && !string.isEmpty()) {
            t.setToolTipText(string);
        }
        t.setMargin(new Insets(2, 2, 2, 2));
        t.setOpaque(false);
        t.setBorderPainted(false);
        t.addMouseListener(S);
        return t;
    }

    public static JButton createSmallButton(Action action, String tooltip) {
        return ButtonFactory.a(LaF.BUTTONFACTORY.createPlainButton(action), tooltip, new Insets(2, 2, 2, 2), 16, 16);
    }

    public static JToggleButton createToggleButton(Action action, String tooltip) {
        JToggleButton jToggleButton = new JToggleButton(action){

            @Override
            public void setSelected(boolean b2) {
                super.setSelected(b2);
                this.setBorderPainted(b2);
            }
        };
        return ButtonFactory.a(jToggleButton, tooltip);
    }

    public static JToggleButton createToggleButton(Icon icon, String tooltip) {
        JToggleButton jToggleButton = new JToggleButton(icon){

            @Override
            public void setSelected(boolean b2) {
                if (b2) {
                    if (this.getClientProperty("selected") != null && ((Boolean)this.getClientProperty("selected")).booleanValue()) {
                        this.requestFocus();
                    } else {
                        this.getFocusCycleRootAncestor().requestFocus();
                    }
                    this.putClientProperty("selected", Boolean.TRUE);
                } else {
                    this.putClientProperty("selected", Boolean.FALSE);
                }
                super.setSelected(b2);
                this.setBorderPainted(b2);
            }
        };
        jToggleButton.setOpaque(false);
        jToggleButton.setBorderPainted(false);
        jToggleButton.addMouseListener(S);
        jToggleButton.setToolTipText(tooltip);
        return jToggleButton;
    }

    public static void createDropDownButton(final JButton invocationButton, JButton selectionButton) {
        ButtonFactory.a(invocationButton, null, new Insets(2, 2, 2, 0), 26, 26);
        selectionButton.setHideActionText(true);
        selectionButton.setMargin(new Insets(2, 0, 2, 2));
        selectionButton.setOpaque(false);
        selectionButton.setBorderPainted(false);
        selectionButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent ev) {
                AbstractButton abstractButton = (AbstractButton)ev.getSource();
                if (abstractButton.isEnabled()) {
                    abstractButton.setBorderPainted(true);
                }
                if (invocationButton.isEnabled()) {
                    invocationButton.setBorderPainted(true);
                    invocationButton.getModel().setRollover(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                AbstractButton abstractButton = (AbstractButton)ev.getSource();
                abstractButton.setBorderPainted(false);
                invocationButton.setBorderPainted(false);
                invocationButton.getModel().setRollover(false);
            }
        });
    }
}

