/*
 * Decompiled with CFR 0.152.
 */
package de.anormalmedia.sbstutorial.gui.step;

import de.anormalmedia.sbstutorial.Tutorial;
import de.anormalmedia.sbstutorial.conditions.Condition;
import de.anormalmedia.sbstutorial.gui.ComponentFinder;
import de.anormalmedia.sbstutorial.gui.ComponentFlasher;
import java.awt.AWTEvent;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Step {
    private String description = "";
    private ArrayList<Condition> eventConditions = new ArrayList();
    private Condition ignoreCondition = null;
    private Condition restartCondition = null;
    private final ComponentFlasher flasher;
    private final Tutorial tutorial;
    public static final int TYPE_STEP = 0;
    public static final int TYPE_INTRO = 1;
    public static final int TYPE_CONCLUSION = 2;
    private int type = 0;
    private final Node stepnode;

    public Step(Node stepnode, ComponentFlasher flasher, Tutorial tutorial) {
        this.stepnode = stepnode;
        this.flasher = flasher;
        this.tutorial = tutorial;
        this.parse(stepnode);
    }

    private void markNextComponent() {
        this.flasher.setComponent(null);
        if (this.eventConditions.size() > 0) {
            Condition nextevent = this.eventConditions.get(0);
            final Condition flashCondition = nextevent.getFlashCondition();
            final Condition subCondition = nextevent.getSubCondition();
            if (flashCondition != null) {
                if (flashCondition.getAttribute("getName") != null && flashCondition.getAttribute("getClass") != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Component findComponent = ComponentFinder.findComponent(flashCondition.getAttribute("getClass"), flashCondition.getAttribute("getName"));
                            Step.this.flasher.setComponent(findComponent);
                        }
                    });
                }
            } else if (subCondition != null && subCondition.getAttribute("getName") != null && subCondition.getAttribute("getClass") != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Component findComponent = ComponentFinder.findComponent(subCondition.getAttribute("getClass"), subCondition.getAttribute("getName"));
                        Step.this.flasher.setComponent(findComponent);
                    }
                });
            }
        }
    }

    public boolean stepPassed(AWTEvent event) {
        Component findComponent;
        if (this.canIgnore()) {
            return true;
        }
        if (event == null) {
            return false;
        }
        if (this.eventConditions.size() > 0) {
            ArrayList<Condition> copy = new ArrayList<Condition>();
            copy.addAll(this.eventConditions);
            for (Condition eventCondition : copy) {
                if (!eventCondition.matches(event)) {
                    return false;
                }
                Condition subCondition = eventCondition.getSubCondition();
                if (subCondition != null && !subCondition.matches(event.getSource())) {
                    return false;
                }
                this.eventConditions.remove(0);
                this.markNextComponent();
            }
        }
        if (this.type != 0) {
            return false;
        }
        if (this.restartCondition != null && this.restartCondition.getAttribute("getName") != null && this.restartCondition.getAttribute("getClass") != null && (findComponent = ComponentFinder.findComponent(this.restartCondition.getAttribute("getClass"), this.restartCondition.getAttribute("getName"))) != null && this.restartCondition.matches(findComponent)) {
            this.parse(this.stepnode);
            this.markNextComponent();
            this.tutorial.notifyListener();
            return false;
        }
        return true;
    }

    private boolean canIgnore() {
        Component findComponent;
        if (this.ignoreCondition != null && this.ignoreCondition.getAttribute("getName") != null && this.ignoreCondition.getAttribute("getClass") != null && (findComponent = ComponentFinder.findComponent(this.ignoreCondition.getAttribute("getClass"), this.ignoreCondition.getAttribute("getName"))) != null && this.ignoreCondition.matches(findComponent)) {
            this.eventConditions.clear();
            this.restartCondition = null;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    private void parse(Node stepnode) {
        this.description = "";
        this.ignoreCondition = null;
        this.restartCondition = null;
        this.eventConditions.clear();
        NodeList childNodes = stepnode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node ffitem;
            NamedNodeMap attributes;
            Node item = childNodes.item(i);
            if ("description".equals(item.getNodeName())) {
                this.description = this.tutorial.getNodeContent(item).trim();
                if (this.description.startsWith("$")) {
                    this.description = this.tutorial.getMsg(this.description, item);
                }
            } else if ("ignorestep".equals(item.getNodeName())) {
                attributes = item.getAttributes();
                int ff = 0;
                while (ff < attributes.getLength()) {
                    ffitem = attributes.item(ff);
                    String nodeValue = ffitem.getNodeValue();
                    if (nodeValue.startsWith("$")) {
                        nodeValue = this.tutorial.getMsg(nodeValue, null);
                        ffitem.setNodeValue(nodeValue);
                    }
                    ++ff;
                }
                this.ignoreCondition = new Condition(attributes);
                this.ignoreCondition.setComponent(true);
            } else if ("restartstep".equals(item.getNodeName())) {
                attributes = item.getAttributes();
                int ff = 0;
                while (ff < attributes.getLength()) {
                    ffitem = attributes.item(ff);
                    String nodeValue = ffitem.getNodeValue();
                    if (nodeValue.startsWith("$")) {
                        nodeValue = this.tutorial.getMsg(nodeValue, null);
                        ffitem.setNodeValue(nodeValue);
                    }
                    ++ff;
                }
                this.restartCondition = new Condition(attributes);
                this.restartCondition.setComponent(true);
            } else if ("waitforevent".equals(item.getNodeName())) {
                attributes = item.getAttributes();
                int ff = 0;
                while (ff < attributes.getLength()) {
                    ffitem = attributes.item(ff);
                    String nodeValue = ffitem.getNodeValue();
                    if (nodeValue.startsWith("$")) {
                        nodeValue = this.tutorial.getMsg(nodeValue, null);
                        ffitem.setNodeValue(nodeValue);
                    }
                    ++ff;
                }
                Condition eventCondition = new Condition(attributes);
                NodeList eventConds = item.getChildNodes();
                int c = 0;
                while (c < eventConds.getLength()) {
                    String nodeValue;
                    Node ffitem2;
                    NamedNodeMap condattributes;
                    Node cond = eventConds.item(c);
                    if ("component".equals(cond.getNodeName())) {
                        condattributes = cond.getAttributes();
                        int ff2 = 0;
                        while (ff2 < condattributes.getLength()) {
                            ffitem2 = condattributes.item(ff2);
                            nodeValue = ffitem2.getNodeValue();
                            if (nodeValue.startsWith("$")) {
                                nodeValue = this.tutorial.getMsg(nodeValue, null);
                                ffitem2.setNodeValue(nodeValue);
                            }
                            ++ff2;
                        }
                        Condition subCondition = new Condition(condattributes);
                        subCondition.setComponent(true);
                        eventCondition.setSubCondition(subCondition);
                    } else if ("flashcomponent".equals(cond.getNodeName())) {
                        condattributes = cond.getAttributes();
                        int ff3 = 0;
                        while (ff3 < condattributes.getLength()) {
                            ffitem2 = condattributes.item(ff3);
                            nodeValue = ffitem2.getNodeValue();
                            if (nodeValue.startsWith("$")) {
                                nodeValue = this.tutorial.getMsg(nodeValue, null);
                                ffitem2.setNodeValue(nodeValue);
                            }
                            ++ff3;
                        }
                        Condition flashCondition = new Condition(condattributes);
                        flashCondition.setComponent(true);
                        eventCondition.setFlashCondition(flashCondition);
                    }
                    ++c;
                }
                this.eventConditions.add(eventCondition);
            }
            ++i;
        }
    }

    public ArrayList<Condition> getEventConditions() {
        return this.eventConditions;
    }

    public void stop() {
        this.flasher.setComponent(null);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setStarted() {
        this.markNextComponent();
    }
}

