/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.image;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.plugin.fs.ResourceFile;
import com.inet.swing.image.RetinaImageIcon;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ImageUtils {
    private static MemoryStoreMap<String, RetinaImageIcon> gE = new MemoryStoreMap();

    private static String a(String string, Class<?> clazz) {
        String string2 = "/" + ResourceFile.createNormalizeChildPath((String)clazz.getName().replace('.', '/'), (String)(string.contains("/") ? "../" : "../images"));
        return ResourceFile.createNormalizeChildPath((String)string2, (String)string);
    }

    public static boolean isMacRetinaDisplay() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
        return 2.0 == affineTransform.getScaleX() && 2.0 == affineTransform.getScaleY();
    }

    @Nonnull
    private static RetinaImageIcon.a b(String string, Class<?> clazz) {
        int n2;
        URL uRL = null;
        if (ImageUtils.isMacRetinaDisplay()) {
            n2 = string.lastIndexOf(46);
            String string2 = string.substring(0, n2) + "@2" + string.substring(n2);
            uRL = clazz.getResource(ImageUtils.a(string2, clazz));
            if (uRL == null) {
                string2 = string.substring(0, n2) + "@2x" + string.substring(n2);
                uRL = clazz.getResource(ImageUtils.a(string2, clazz));
            }
            if (uRL == null) {
                int n3 = string.lastIndexOf(95, n2);
                try {
                    String string3 = string.substring(n3 + 1, n2);
                    int n4 = Integer.parseInt(string3) * 2;
                    string2 = string.substring(0, n3 + 1) + n4 + string.substring(n2);
                    uRL = clazz.getResource(ImageUtils.a(string2, clazz));
                }
                catch (NumberFormatException | StringIndexOutOfBoundsException runtimeException) {
                    // empty catch block
                }
            }
        }
        n2 = 0;
        if (uRL == null) {
            uRL = clazz.getResource(ImageUtils.a(string, clazz));
        } else {
            n2 = 1;
        }
        return new RetinaImageIcon.a(uRL, n2 != 0);
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private static RetinaImageIcon.a b(URL uRL) {
        URL uRL2 = null;
        if (ImageUtils.isMacRetinaDisplay() && uRL.getProtocol().startsWith("file:")) {
            String string = uRL.toString();
            int n2 = string.lastIndexOf(46);
            try {
                String string2 = string.substring(0, n2) + "@2" + string.substring(n2);
                uRL2 = ImageUtils.s(string2);
                if (uRL2 == null || !new File(uRL2.toURI()).exists()) {
                    string2 = string.substring(0, n2) + "@2x" + string.substring(n2);
                    uRL2 = ImageUtils.s(string2);
                }
                if (uRL2 == null || !new File(uRL2.toURI()).exists()) {
                    int n3 = string.lastIndexOf(95, n2);
                    String string3 = string.substring(n3 + 1, n2);
                    int n4 = Integer.parseInt(string3) * 2;
                    string2 = string.substring(0, n3 + 1) + n4 + string.substring(n2);
                    uRL2 = new URL(string2);
                    if (!new File(uRL2.toURI()).exists()) {
                        uRL2 = null;
                    }
                }
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException | MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        boolean bl = false;
        if (uRL2 == null) {
            uRL2 = uRL;
        } else {
            bl = true;
        }
        return new RetinaImageIcon.a(uRL2, bl);
    }

    private static URL s(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Nullable
    public static RetinaImageIcon getImageIcon(URL location) {
        RetinaImageIcon.a a2;
        String string = location.toString() + "." + ImageUtils.isMacRetinaDisplay();
        RetinaImageIcon retinaImageIcon = (RetinaImageIcon)gE.get((Object)string);
        if (retinaImageIcon == null && (a2 = ImageUtils.b(location)).ai() != null) {
            retinaImageIcon = new RetinaImageIcon(a2);
            gE.put((Object)string, (Object)retinaImageIcon);
        }
        return retinaImageIcon;
    }

    @Nullable
    public static RetinaImageIcon getImageIcon(String name, Class<?> base) {
        RetinaImageIcon.a a2;
        String string = base.toString() + "." + name + "." + ImageUtils.isMacRetinaDisplay();
        RetinaImageIcon retinaImageIcon = (RetinaImageIcon)gE.get((Object)string);
        if (retinaImageIcon == null && (a2 = ImageUtils.b(name, base)).ai() != null) {
            retinaImageIcon = new RetinaImageIcon(a2);
            gE.put((Object)string, (Object)retinaImageIcon);
        }
        return retinaImageIcon;
    }

    @Nullable
    public static BufferedImage getImage(String name, Class<?> base) throws IOException {
        RetinaImageIcon retinaImageIcon = ImageUtils.getImageIcon(name, base);
        if (retinaImageIcon == null) {
            return null;
        }
        return ImageUtils.a(retinaImageIcon);
    }

    @Nullable
    public static BufferedImage getImage(URL location) throws IOException {
        RetinaImageIcon retinaImageIcon = ImageUtils.getImageIcon(location);
        if (retinaImageIcon == null) {
            return null;
        }
        return ImageUtils.a(retinaImageIcon);
    }

    private static BufferedImage a(RetinaImageIcon retinaImageIcon) {
        Image image = retinaImageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getWidth(null), 2);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    static {
        gE.setTimeout(300, true);
    }
}

