/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing;

import com.inet.annotations.InternalApi;
import com.inet.swing.LaF;
import com.inet.swing.widgets.TristateComponent;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;

@InternalApi
public class NumericTextField
extends JFormattedTextField
implements TristateComponent {
    private boolean am = false;
    private boolean an = false;
    private Color ao = new JFormattedTextField().getBackground();
    private boolean ap;
    public static final String SILENT = "SILENT";

    public NumericTextField() {
        this(null, 0, null);
    }

    public NumericTextField(String text, int columns, DecimalFormat format) {
        super(new NumberFormatter(format));
        this.setText(text);
        this.setColumns(columns);
        if (format == null) {
            this.setFormat(new DecimalFormat());
        }
        Document document = this.getDocument();
        document.addDocumentListener(new a());
    }

    public NumericTextField(int columns, DecimalFormat format) {
        this(null, columns, format);
    }

    public NumericTextField(String text) {
        this(text, 0, null);
    }

    public NumericTextField(String text, int columns) {
        this(text, columns, null);
    }

    public void setFormat(DecimalFormat format) {
        ((NumberFormatter)super.getFormatter()).setFormat(format);
        if (this.ap) {
            ((NumberFormatter)super.getFormatter()).setMinimum(Double.valueOf(0.0));
        } else {
            ((NumberFormatter)super.getFormatter()).setMinimum(Double.valueOf(-1.7976931348623157E308));
        }
        this.setValue(this.getValue());
    }

    public DecimalFormat getFormat() {
        return (DecimalFormat)((NumberFormatter)super.getFormatter()).getFormat();
    }

    public Double getDoubleValue() throws ParseException {
        if (this.isTristate()) {
            return null;
        }
        Number number = this.getNumberValue();
        if (!(number instanceof Long) && !(number instanceof Double)) {
            throw new ParseException("Not a valid double", 0);
        }
        if (number instanceof Long) {
            number = number.doubleValue();
        }
        return (Double)number;
    }

    public Number getNumberValue() throws ParseException {
        if (this.isTristate()) {
            return null;
        }
        Object object = this.getValue();
        return (Number)object;
    }

    @Override
    protected void processFocusEvent(FocusEvent ev) {
        super.processFocusEvent(ev);
        if (ev.getID() == 1004) {
            this.selectAll();
        }
    }

    public void setValue(long l2) {
        this.setValue((Object)l2);
    }

    public void setValue(double d2) {
        this.setValue((Object)d2);
    }

    public void setValueSilent(long l2) {
        this.putClientProperty(SILENT, Boolean.TRUE);
        this.setValue((Object)l2);
        this.putClientProperty(SILENT, Boolean.FALSE);
    }

    public void setValueSilent(double d2) {
        this.putClientProperty(SILENT, Boolean.TRUE);
        this.setValue((Object)d2);
        this.putClientProperty(SILENT, Boolean.FALSE);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public boolean isTristate() {
        return this.am;
    }

    @Override
    public void setTristate(boolean tristate) {
        this.an = true;
        this.am = tristate;
        if (tristate) {
            this.setValue(null);
            this.setBackground(LaF.CLR_GRADIENT);
        } else if (this.ao != null) {
            this.setBackground(this.ao);
        }
    }

    public void setOnlyPositivNumbersAllowed(boolean b2) {
        this.ap = b2;
        this.setFormat(this.getFormat());
    }

    class a
    implements DocumentListener {
        a() {
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            if (NumericTextField.this.an) {
                NumericTextField.this.setTristate(false);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            if (NumericTextField.this.an) {
                NumericTextField.this.setTristate(false);
            }
        }
    }
}

