/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.webapi;

import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.JsonException;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.report.plugins.datasources.server.base.d;
import com.inet.report.plugins.datasources.server.data.DownloadDatasourceRequestHandler;
import com.inet.report.plugins.datasources.server.data.GetDatasourceListRequestData;
import com.inet.report.plugins.datasources.server.data.GetDatasourceListResponseData;
import com.inet.shared.servlet.ServletUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Datasources", description="Operations for managing datasources")
public class a
extends RequestHandler<Void, Void> {
    public a() {
        super(new String[]{"export"});
    }

    public String getHelpPageKey() {
        return "datasources.api.export";
    }

    @Operation(summary="Export all available datasources", description="Exports all datasources that are available to the current user as an XML file")
    @ApiResponse(responseCode="200", description="Successfully exported datasources", content={@Content(mediaType="application/xml")})
    public Void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl) throws IOException {
        com.inet.report.plugins.datasources.server.base.a a2 = new com.inet.report.plugins.datasources.server.base.a();
        d d2 = new d();
        GetDatasourceListRequestData getDatasourceListRequestData = new GetDatasourceListRequestData();
        try {
            getDatasourceListRequestData = (GetDatasourceListRequestData)d2.a(httpServletRequest);
        }
        catch (JsonException | EOFException throwable) {
            // empty catch block
        }
        GetDatasourceListResponseData getDatasourceListResponseData = d2.a(getDatasourceListRequestData);
        List<GUID> list = getDatasourceListResponseData.getDataEntries().stream().map(datasourceListEntry -> datasourceListEntry.getUuid()).collect(Collectors.toList());
        DownloadDatasourceRequestHandler downloadDatasourceRequestHandler = new DownloadDatasourceRequestHandler();
        downloadDatasourceRequestHandler.setDatasourceIDs(list);
        FastByteArrayOutputStream fastByteArrayOutputStream = a2.a(downloadDatasourceRequestHandler);
        FastByteArrayInputStream fastByteArrayInputStream = new FastByteArrayInputStream(fastByteArrayOutputStream.toByteArray());
        ServletUtils.setContentDisposition((HttpServletResponse)httpServletResponse, (String)a2.a(), (boolean)false);
        ServletUtils.sendStaticContent((String)"text/xml; charset=utf-8", (long)0L, (long)0L, (InputStream)fastByteArrayInputStream, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (OutputStream)httpServletResponse.getOutputStream());
        return null;
    }

    public Boolean coreServletHasToHandleRequest(HttpServletRequest request, List<String> pathTokens) {
        return Boolean.TRUE;
    }

    @Operation(summary="Export all available datasources", description="Exports all datasources that are available to the current user as an XML file")
    @ApiResponse(responseCode="200", description="Successfully exported datasources", content={@Content(mediaType="application/xml")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, bl);
    }
}

