/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.data.datasource;

import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.Encryption;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.widget.DriverProperty;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.plugins.datasources.server.data.DatasourceRequestData;
import com.inet.report.plugins.datasources.server.data.datasource.DatasourceValueHolder;
import com.inet.report.plugins.datasources.server.data.permissions.a;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class DatasourceData
extends DatasourceRequestData {
    private Map<String, String> data = new HashMap<String, String>();

    public DataSourceConfiguration asTempDatasourceConfiguration(GUID sourceDatasourceId) {
        String string;
        DriverStyleSheetFactory driverStyleSheetFactory = DriverStyleSheetFactory.getInstance((Locale)ClientLocale.getThreadLocale());
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((GUID)this.getDatasourceId());
        if (dataSourceConfiguration == null && sourceDatasourceId != null && (dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((GUID)sourceDatasourceId)) == null) {
            return null;
        }
        DataSourceConfiguration dataSourceConfiguration2 = DataSourceConfigurationManager.createDataSourceConfiguration((String)(dataSourceConfiguration != null ? dataSourceConfiguration.getConfigurationName() : "Data"), (int)0);
        DriverStyleSheet driverStyleSheet = null;
        if (dataSourceConfiguration != null) {
            driverStyleSheet = driverStyleSheetFactory.getDriverStylesheetByDataSourceConfiguration(dataSourceConfiguration);
            if (driverStyleSheet != null) {
                dataSourceConfiguration2.putStylesheetDefaultValues(driverStyleSheet);
            }
            dataSourceConfiguration2.addProperties(dataSourceConfiguration.getProperties());
        }
        if ((string = this.data.get("datasourceInternalDbms")) != null && (driverStyleSheet = com.inet.report.plugins.datasources.server.utils.a.a(GUID.valueOf((String)string))) != null) {
            dataSourceConfiguration2 = com.inet.report.plugins.datasources.server.utils.a.b(dataSourceConfiguration2, driverStyleSheetFactory, driverStyleSheet);
        }
        this.addDiffsData(dataSourceConfiguration2, driverStyleSheet);
        this.cleanLeftOverData(dataSourceConfiguration2);
        return dataSourceConfiguration2;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public void addDiffsData(@Nonnull DataSourceConfiguration dsc, DriverStyleSheet driverStyleSheet) {
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2 == null || DatasourceValueHolder.DATASOURCE_INTERNAL_KEYS.contains(string)) continue;
            if (driverStyleSheet != null) {
                for (int i2 = 0; i2 < driverStyleSheet.getPropertyCount(); ++i2) {
                    DriverProperty driverProperty = driverStyleSheet.getDriverProperty(i2);
                    if (driverProperty.getType() != 10 || !driverProperty.getName().equals(string)) continue;
                    Json json = new Json();
                    HashMap hashMap = (HashMap)json.fromJson(string2, HashMap.class);
                    String string3 = (String)hashMap.get("password");
                    if (string3 == null) break;
                    try {
                        Encryption.decodePassword((String)string3);
                    }
                    catch (Exception exception) {
                        try {
                            hashMap.put("password", Encryption.encodePassword((String)string3));
                        }
                        catch (IOException iOException) {
                            ErrorCode.throwAny((Throwable)iOException);
                        }
                        string2 = json.toJson((Object)hashMap);
                    }
                    break;
                }
            }
            dsc.addProperty(string, string2);
        }
    }

    public void cleanLeftOverData(DataSourceConfiguration dsc) {
        Set set = this.data.entrySet().stream().filter(x -> x.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
        dsc.removeProperties(set);
    }

    @Nullable
    public String getTitle() {
        return this.data.get("datasourceInternalTitle");
    }

    @Nullable
    public String getDBMSUUID() {
        return this.data.get("datasourceInternalDbms");
    }

    @Nullable
    public Set<GUID> getPermissions() {
        String string = this.data.get("datasourceInternalPermissions");
        if (string == null || string.isEmpty()) {
            return null;
        }
        return a.a(string);
    }
}

