/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.handler;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.widget.DriverProperty;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.plugins.datasources.DatasourcesServerPlugin;
import com.inet.report.plugins.datasources.server.data.DatasourceRequestData;
import com.inet.report.plugins.datasources.server.data.GetDatasourceResponseData;
import com.inet.report.plugins.datasources.server.data.datasource.DatasourceValueHolder;
import com.inet.report.plugins.datasources.server.handler.a;
import com.inet.usersandgroups.UsersAndGroups;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nonnull;

public class j
extends a<DatasourceRequestData, GetDatasourceResponseData> {
    public String getMethodName() {
        return "load-datasource";
    }

    public GetDatasourceResponseData b(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, DatasourceRequestData datasourceRequestData) throws IOException {
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((GUID)datasourceRequestData.getDatasourceId());
        if (dataSourceConfiguration == null) {
            throw new ClientMessageException(DatasourcesServerPlugin.MSG.getMsg("datasources.missing", new Object[0]));
        }
        DriverStyleSheetFactory driverStyleSheetFactory = DriverStyleSheetFactory.getInstance((Locale)httpServletRequest.getLocale());
        DriverStyleSheet driverStyleSheet = driverStyleSheetFactory.getDriverStylesheetByDataSourceConfiguration(dataSourceConfiguration);
        if (driverStyleSheet == null) {
            driverStyleSheet = driverStyleSheetFactory.getDefaultDriverStyleSheet();
        }
        GetDatasourceResponseData getDatasourceResponseData = j.a(dataSourceConfiguration, driverStyleSheetFactory, driverStyleSheet);
        return getDatasourceResponseData;
    }

    public static GetDatasourceResponseData a(DataSourceConfiguration dataSourceConfiguration, DriverStyleSheetFactory driverStyleSheetFactory, DriverStyleSheet driverStyleSheet) {
        GetDatasourceResponseData getDatasourceResponseData = new GetDatasourceResponseData(dataSourceConfiguration, dataSourceConfiguration.getConfigurationName());
        getDatasourceResponseData.addDatasourceSetting("driver.group.basic", DatasourceValueHolder.titleHolder(dataSourceConfiguration));
        getDatasourceResponseData.addLocalization(new LocalizedKey("datasourceInternalTitle", DatasourcesServerPlugin.CONFIG_MSG.getMsg("datasourceInternalTitle", new Object[0])));
        getDatasourceResponseData.addDatasourceSetting("driver.group.basic", DatasourceValueHolder.dbmsTypeHolder(driverStyleSheet, driverStyleSheetFactory));
        getDatasourceResponseData.addLocalization(new LocalizedKey("datasourceInternalDbms", DatasourcesServerPlugin.CONFIG_MSG.getMsg("datasourceInternalDbms", new Object[0])));
        for (int i2 = 0; i2 < driverStyleSheet.getPropertyCount(); ++i2) {
            DriverProperty driverProperty = driverStyleSheet.getDriverProperty(i2);
            String string = driverProperty.getGroup();
            if (driverProperty.getType() != 9) {
                getDatasourceResponseData.addLocalization(new LocalizedKey(string, driverProperty.getGroupDisplayName()));
                getDatasourceResponseData.addLocalization(new LocalizedKey(driverProperty.getName(), driverProperty.getDisplayName()));
            }
            getDatasourceResponseData.addDatasourceSetting(string, DatasourceValueHolder.from(dataSourceConfiguration, driverProperty));
        }
        if (driverStyleSheet.getDisplayName().equals("DefaultDriver")) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(dataSourceConfiguration.getDriverSpecificProperties()));
            com.inet.report.plugins.datasources.server.utils.a.a(arrayList);
            getDatasourceResponseData.addLocalization(new LocalizedKey("driver.group.custom", DatasourcesServerPlugin.CONFIG_MSG.getMsg("driver.group.custom", new Object[0])));
            for (String string : arrayList) {
                getDatasourceResponseData.addDatasourceSetting("driver.group.custom", DatasourceValueHolder.customHolder(dataSourceConfiguration, string));
            }
            getDatasourceResponseData.addDatasourceSetting("driver.group.custom", DatasourceValueHolder.customHolder(dataSourceConfiguration, ""));
        }
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER) && !DatasourcesServerPlugin.isRestricted(dataSourceConfiguration).booleanValue() && (dataSourceConfiguration.getScope() == 7 || dataSourceConfiguration.getScope() == 0)) {
            getDatasourceResponseData.addLocalization(new LocalizedKey("driver.group.permissions", DatasourcesServerPlugin.CONFIG_MSG.getMsg("driver.group.permissions", new Object[0])));
            getDatasourceResponseData.addDatasourceSetting("driver.group.permissions", DatasourceValueHolder.permissionsHolder(dataSourceConfiguration));
        }
        return getDatasourceResponseData;
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (DatasourceRequestData)object);
    }
}

