/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.data;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.plugins.datasources.DatasourcesServerPlugin;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

@JsonData
public class DatasourceListEntry {
    private String title;
    private String alias;
    private GUID uuid;
    private String permissions;
    private String type;
    private Boolean readonly = Boolean.FALSE;
    private List<LocalizedKey> additionalInformation;
    private int scope;
    private static Map<String, Integer> previewDisplayKeysToPrio = new HashMap<String, Integer>(){
        {
            this.put("host", 1000);
            this.put("database", 900);
            this.put("datasource", 800);
            this.put("server", 700);
            this.put("f", 606);
            this.put("ldapurl", 605);
            this.put("file", 604);
            this.put("path", 603);
            this.put("dbpath", 602);
            this.put("catalog", 500);
            this.put("schema", 400);
            this.put("sid", 300);
            this.put("user", 200);
            this.put("port", 100);
        }
    };
    private static long MAX_NUMBER_OF_ADDITIONAL_ENTRIES = 4L;

    public static DatasourceListEntry fromDatasource(int scope, DataSourceConfiguration configuration, DriverStyleSheetFactory styleSheetFactory, String permissionsString) {
        HashMap hashMap = new HashMap();
        configuration.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key != null) {
                hashMap.put(key.toString(), value != null ? value.toString() : null);
            }
        }));
        Set<String> set = previewDisplayKeysToPrio.keySet();
        Comparator comparator = (o1, o2) -> {
            Integer n = previewDisplayKeysToPrio.get(o1.getKey());
            Integer n2 = previewDisplayKeysToPrio.get(o2.getKey());
            return (n2 == null ? 0 : n2) - (n == null ? 0 : n);
        };
        DriverStyleSheet driverStyleSheet = styleSheetFactory.getDriverStylesheetByDataSourceConfiguration(configuration);
        if (driverStyleSheet == null) {
            driverStyleSheet = styleSheetFactory.getDefaultDriverStyleSheet();
        }
        DriverStyleSheet driverStyleSheet2 = driverStyleSheet;
        List list = hashMap.entrySet().stream().filter(e2 -> set.contains(((String)e2.getKey()).toLowerCase()) && e2.getValue() != null && ((String)e2.getValue()).trim().length() > 0).sorted(comparator).limit(MAX_NUMBER_OF_ADDITIONAL_ENTRIES).map(e2 -> {
            String string;
            String string2 = string = (String)e2.getKey();
            for (int i2 = 0; i2 < driverStyleSheet2.getPropertyCount(); ++i2) {
                String string3;
                if (!string.equalsIgnoreCase(driverStyleSheet2.getDriverProperty(i2).getName()) || (string3 = driverStyleSheet2.getDriverProperty(i2).getDisplayName()).trim().length() <= 0) continue;
                string2 = string3;
                break;
            }
            if (string2.equals(string) && (string2 = DatasourcesServerPlugin.CONFIG_MSG.getMsg(string, new Object[0])).equals("$" + string + "$")) {
                string2 = string;
            }
            return new LocalizedKey(string2, (String)e2.getValue());
        }).collect(Collectors.toList());
        DatasourceListEntry datasourceListEntry = new DatasourceListEntry();
        datasourceListEntry.title = datasourceListEntry.alias = configuration.getConfigurationName();
        datasourceListEntry.uuid = configuration.getUID();
        datasourceListEntry.permissions = permissionsString;
        datasourceListEntry.type = DatasourceListEntry.getDriverDisplayName(configuration, styleSheetFactory);
        datasourceListEntry.additionalInformation = list;
        datasourceListEntry.readonly = DatasourcesServerPlugin.isRestricted(configuration);
        datasourceListEntry.scope = scope;
        return datasourceListEntry;
    }

    public static String getDriverDisplayName(DataSourceConfiguration configuration, DriverStyleSheetFactory styleSheetFactory) {
        DriverStyleSheet driverStyleSheet = styleSheetFactory.getDriverStylesheetByDataSourceConfiguration(configuration);
        if (driverStyleSheet == null) {
            String string = configuration.getDriverClassname();
            if (string != null && string.length() > 0) {
                return string;
            }
            String string2 = configuration.getDatabaseClassname();
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            return "";
        }
        return driverStyleSheet.getDisplayName();
    }

    public static int compare(DatasourceListEntry first, DatasourceListEntry second) {
        if (first.title.equalsIgnoreCase(second.title)) {
            if (first.alias.equalsIgnoreCase(second.alias)) {
                return first.scope == second.scope ? 0 : (first.scope > second.scope ? 1 : -1);
            }
            return first.alias.compareTo(second.alias);
        }
        return first.title.compareTo(second.title);
    }

    public String getTitle() {
        return this.title;
    }

    public String getAlias() {
        return this.alias;
    }

    public GUID getUuid() {
        return this.uuid;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getReadonly() {
        return this.readonly;
    }

    public List<LocalizedKey> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public int getScope() {
        return this.scope;
    }
}

