/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.help;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.help.api.model.VirtualHelpPage;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.report.config.datasource.widget.DriverProperty;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.plugins.datasources.DatasourcesServerPlugin;
import com.inet.report.plugins.datasources.server.utils.a;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.TextNode;

@JsonData
public class DataSourceDriverHelpPage
extends VirtualHelpPage {
    private static final String DATASOURCE_DRIVER_HELPPAGE = "datasources-driver-helppage-";
    private String specificKey;
    private String displayName = "datasources-driver-helppage-";
    private Locale locale;
    private URLStreamHandler urlStreamHandler;
    private String driverDocument;

    public DataSourceDriverHelpPage() {
        this(DATASOURCE_DRIVER_HELPPAGE, Locale.getDefault());
    }

    public DataSourceDriverHelpPage(String key, Locale locale) {
        this.specificKey = key;
        this.locale = locale;
    }

    public DataSourceDriverHelpPage(LocalizedKey localizedKey, Locale locale) {
        this(localizedKey.getKey(), locale);
        this.displayName = localizedKey.getDisplayName();
    }

    @Nonnull
    public String getExtensionName() {
        return this.getKey();
    }

    @Nonnull
    public String getKey() {
        return DataSourceDriverHelpPage.getKey(this.specificKey);
    }

    public static String getKey(String key) {
        return DATASOURCE_DRIVER_HELPPAGE + key;
    }

    @Nonnull
    public String getTitle() {
        return this.displayName;
    }

    public String getUrl() {
        return this.getKey();
    }

    public String getPageKeyForUrl(String url, Locale locale) {
        return url.contains(this.getKey()) ? this.getKey() : null;
    }

    public boolean isKeyFromPage(@Nonnull String key, Locale locale) {
        return key.startsWith(DATASOURCE_DRIVER_HELPPAGE);
    }

    public URL getResourceForName(String name) {
        try {
            return this.getKey().equals(name) ? new URL(new URL("file://"), this.specificKey, this.getURLStreamHandler()) : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private URLStreamHandler getURLStreamHandler() {
        if (this.urlStreamHandler == null) {
            this.urlStreamHandler = new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(DataSourceDriverHelpPage.this.getDriverDocumentForId());
                        }

                        @Override
                        public void connect() throws IOException {
                        }
                    };
                }
            };
        }
        return this.urlStreamHandler;
    }

    private byte[] getDriverDocumentForId() {
        if (this.driverDocument == null) {
            String string;
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            DriverStyleSheetFactory driverStyleSheetFactory = DriverStyleSheetFactory.getInstance((Locale)this.locale);
            DriverStyleSheet driverStyleSheet = a.a(GUID.valueOf((String)this.specificKey), driverStyleSheetFactory);
            if (driverStyleSheet == null) {
                throw new ClientMessageException(DatasourcesServerPlugin.MSG.getMsg("datasources.missing", new Object[0]));
            }
            stringBuilder.append("<h1>");
            stringBuilder.append(driverStyleSheet.getDisplayName());
            stringBuilder.append("</h1>");
            stringBuilder.append("<div class=\"level1\">");
            stringBuilder.append("<p>");
            stringBuilder.append(driverStyleSheet.getDescription());
            stringBuilder.append("</p>");
            stringBuilder.append("</div>");
            String string3 = null;
            for (int i2 = 0; i2 < driverStyleSheet.getPropertyCount(); ++i2) {
                DriverProperty driverProperty = driverStyleSheet.getDriverProperty(i2);
                if (driverProperty.getType() == 9) continue;
                String string4 = driverProperty.getName();
                string2 = driverProperty.getDisplayName();
                if (string2 == null || string2.length() == 0) {
                    string2 = DataSourceDriverHelpPage.getDriverPropertyName(string4);
                }
                if (string3 != driverProperty.getGroup()) {
                    if (string3 != null) {
                        stringBuilder.append("</tbody></table></div></div>");
                    }
                    string3 = driverProperty.getGroup();
                    string = driverProperty.getGroupDisplayName();
                    if (string == null || string.length() == 0) {
                        string = DataSourceDriverHelpPage.getDriverPropertyName(string3);
                    }
                    stringBuilder.append("<h3>");
                    stringBuilder.append(string);
                    stringBuilder.append("</h3><div class=\"level3\"><div class=\"table\"><table class=\"inline\"><thead>");
                    stringBuilder.append("<tr><th>");
                    stringBuilder.append(DatasourcesServerPlugin.CONFIG_MSG.getMsg("property.name", new Object[0])).append("</th>").append("<th>");
                    stringBuilder.append(DatasourcesServerPlugin.CONFIG_MSG.getMsg("property.description", new Object[0])).append("</th></tr>").append("</thead></tbody>");
                }
                stringBuilder.append("<tr>").append("<th valign=\"top\">");
                stringBuilder.append(string2).append("</th>").append("<td valign=\"top\">");
                stringBuilder.append(driverProperty.getHelp()).append("</td>").append("</tr>");
            }
            stringBuilder.append("</tbody></table></div></div>");
            try {
                Document document = Jsoup.parse((InputStream)DataSourceDriverHelpPage.class.getResourceAsStream("template/driver-template.html"), null, (String)"");
                document.outputSettings().escapeMode(Entities.EscapeMode.extended);
                document.outputSettings().charset("ASCII");
                for (String string4 : document.getElementsByTag("abbr")) {
                    string2 = string4.childNode(0);
                    if (!string2.getClass().equals(TextNode.class) || !((TextNode)string2).text().trim().equals("DATASOURCE-LIST-OF-DRIVERS")) continue;
                    string = Jsoup.parseBodyFragment((String)stringBuilder.toString());
                    string4.replaceWith(string.childNode(0));
                    this.driverDocument = document.html();
                    break;
                }
            }
            catch (IOException iOException) {
                throw new ClientMessageException(DatasourcesServerPlugin.MSG.getMsg("datasources.missing", new Object[0]));
            }
        }
        return this.driverDocument.getBytes();
    }

    @Nonnull
    private static String getDriverPropertyName(String propertyName) {
        String string = DatasourcesServerPlugin.CONFIG_MSG.getMsgAllowMissing(propertyName, new Object[0]);
        return string == null ? propertyName : string;
    }

    public VirtualHelpPage getSpecificHelpPage(@Nonnull String key, Locale locale) {
        return new DataSourceDriverHelpPage(key, locale);
    }

    public boolean addRootPageToRoots() {
        return true;
    }

    public boolean showInToc() {
        return SystemPermissionChecker.checkAccess((Permission)DatasourcesServerPlugin.PERMISSION_DATASOURCES);
    }
}

