/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources.server.data.datasource;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.oauth.connection.api.provider.OauthConnectionProvider;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DriverFinder;
import com.inet.report.config.datasource.widget.DriverProperty;
import com.inet.report.config.datasource.widget.DriverStyleSheet;
import com.inet.report.config.datasource.widget.DriverStyleSheetFactory;
import com.inet.report.plugins.datasources.DatasourcesServerPlugin;
import com.inet.report.plugins.datasources.server.data.datasource.a;
import com.inet.usersandgroups.api.ui.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

@JsonData
public class DatasourceValueHolder {
    public static final String DATASOURCE_INTERNAL_TITLE = "datasourceInternalTitle";
    public static final String DATASOURCE_INTERNAL_DBMS = "datasourceInternalDbms";
    protected static final String DATASOURCE_INTERNAL_PERMISSIONS = "datasourceInternalPermissions";
    public static final List<String> DATASOURCE_INTERNAL_KEYS = Arrays.asList("datasourceInternalTitle", "datasourceInternalDbms", "datasourceInternalPermissions");
    private static final boolean OAUTH = ServerPluginManager.getInstance().isPluginLoaded("oauth.connection");
    private String value;
    private a type;
    private String key;
    private String tooltip;
    private List<LocalizedKey> valueChoice;

    @Nullable
    public static DatasourceValueHolder from(DataSourceConfiguration datasource, DriverProperty driverProperty) {
        Object object;
        DatasourceValueHolder datasourceValueHolder = new DatasourceValueHolder();
        datasourceValueHolder.type = a.b(driverProperty.getType());
        datasourceValueHolder.key = DatasourceValueHolder.trim(driverProperty.getName());
        if (datasourceValueHolder.type == null) {
            return null;
        }
        if (datasourceValueHolder.type == a.m) {
            return null;
        }
        if (datasourceValueHolder.type == a.k) {
            object = new char[datasource.getProperty(datasourceValueHolder.key).length()];
            Arrays.fill((char[])object, '*');
            datasourceValueHolder.value = new String((char[])object);
        } else {
            datasourceValueHolder.value = DatasourceValueHolder.trim(datasource.getProperty(datasourceValueHolder.key));
        }
        datasourceValueHolder.tooltip = DatasourceValueHolder.trim(driverProperty.getHelp());
        object = driverProperty.getValueChoice();
        if (object != null && object.size() > 0) {
            datasourceValueHolder.valueChoice = new ArrayList<LocalizedKey>();
            object.forEach((key, value) -> holder.valueChoice.add(new LocalizedKey(key, value)));
            datasourceValueHolder.valueChoice.sort(DatasourceValueHolder.sortLocalizedKeys());
            datasourceValueHolder.type = a.o;
        } else if (datasourceValueHolder.type == a.j) {
            datasourceValueHolder.valueChoice = new ArrayList<LocalizedKey>();
            if (datasource.getCatalog() != null) {
                datasourceValueHolder.valueChoice.add(new LocalizedKey(datasource.getCatalog(), datasource.getCatalog()));
            }
        } else if (OAUTH && datasourceValueHolder.type == a.n) {
            ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
            for (String string : OauthAccessTokenManager.getConfiguredProviderIDs()) {
                OauthConnectionProvider oauthConnectionProvider = OauthAccessTokenManager.getProvider((String)string);
                if (oauthConnectionProvider == null) continue;
                arrayList.add(new LocalizedKey(string, oauthConnectionProvider.getDisplayName()));
            }
            datasourceValueHolder.valueChoice = arrayList;
        }
        return datasourceValueHolder;
    }

    public static DatasourceValueHolder titleHolder(DataSourceConfiguration datasource) {
        DatasourceValueHolder datasourceValueHolder = new DatasourceValueHolder();
        datasourceValueHolder.key = DATASOURCE_INTERNAL_TITLE;
        datasourceValueHolder.value = datasource.getConfigurationName();
        datasourceValueHolder.type = a.f;
        return datasourceValueHolder;
    }

    public static DatasourceValueHolder customHolder(DataSourceConfiguration datasource, String key) {
        DatasourceValueHolder datasourceValueHolder = new DatasourceValueHolder();
        datasourceValueHolder.key = key;
        datasourceValueHolder.value = datasource.getProperty(key);
        datasourceValueHolder.type = a.r;
        return datasourceValueHolder;
    }

    public static DatasourceValueHolder dbmsTypeHolder(DriverStyleSheet currentDatasourceStylesheet, DriverStyleSheetFactory styleSheetFactory) {
        DatasourceValueHolder datasourceValueHolder = new DatasourceValueHolder();
        datasourceValueHolder.key = DATASOURCE_INTERNAL_DBMS;
        datasourceValueHolder.value = com.inet.report.plugins.datasources.server.utils.a.a(currentDatasourceStylesheet).toString();
        datasourceValueHolder.type = a.p;
        datasourceValueHolder.valueChoice = new ArrayList<LocalizedKey>();
        HashMap hashMap = new HashMap();
        DriverFinder.getInstance((Locale)ClientLocale.getThreadLocale()).loadAllDrivers(new ArrayList(), hashMap);
        Collection collection = hashMap.values();
        for (DriverStyleSheet driverStyleSheet : styleSheetFactory.getDriverStyleSheets()) {
            String string = driverStyleSheet.getDriverClassName();
            String string2 = driverStyleSheet.getDisplayName();
            if (!collection.contains(string) && !"DefaultDriver".equals(string2) && !currentDatasourceStylesheet.getDriverClassName().equals(string)) continue;
            if ("DefaultDriver".equals(string2)) {
                string2 = DatasourcesServerPlugin.CONFIG_MSG.getMsg("defaultDriver.displayName", new Object[0]);
            }
            datasourceValueHolder.valueChoice.add(new LocalizedKey(com.inet.report.plugins.datasources.server.utils.a.a(driverStyleSheet).toString(), string2));
        }
        datasourceValueHolder.valueChoice.sort(DatasourceValueHolder.sortLocalizedKeys());
        return datasourceValueHolder;
    }

    private static Comparator<LocalizedKey> sortLocalizedKeys() {
        String string = DatasourcesServerPlugin.CONFIG_MSG.getMsg("defaultDriver.displayName", new Object[0]);
        return (value1, value2) -> {
            if (value1.getDisplayName().equals(string)) {
                return 1;
            }
            return value1.getDisplayName().compareTo(value2.getDisplayName());
        };
    }

    private static String trim(String input) {
        if (input != null) {
            return input.trim();
        }
        return null;
    }

    public static DatasourceValueHolder permissionsHolder(DataSourceConfiguration datasource) {
        HashMap<Type, Set<GUID>> hashMap = new HashMap<Type, Set<GUID>>();
        hashMap.put(Type.group, datasource.getAllowedUserGroups());
        DatasourceValueHolder datasourceValueHolder = new DatasourceValueHolder();
        datasourceValueHolder.key = DATASOURCE_INTERNAL_PERMISSIONS;
        datasourceValueHolder.value = new Json().toJson(com.inet.report.plugins.datasources.server.data.permissions.a.a(hashMap));
        datasourceValueHolder.type = a.q;
        return datasourceValueHolder;
    }

    public String getKey() {
        return this.key;
    }

    public List<LocalizedKey> getValueChoice() {
        return this.valueChoice;
    }

    public a getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

