/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.datasources;

import com.inet.classloader.I18nMessages;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.PluginServlet;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.remote.gui.IModule;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.plugins.datasources.b;
import com.inet.report.plugins.datasources.server.help.a;
import com.inet.report.plugins.datasources.server.webapi.d;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.UsersAndGroups;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@PluginInfo(id="datasource", dependencies="reporting", optionalDependencies="theme;help;maintenance;usersandgroupsmanager;webapi.core;remotegui;oauth.connection", group="reporting;applications;datasource;webapi", packages="com.inet.report.plugins.datasources", version="25.10.198", icon="com/inet/report/plugins/datasources/client/images/datasources_48.png", flags="helpdesk")
public class DatasourcesServerPlugin
implements ServerPlugin {
    public static final Permission PERMISSION_DATASOURCES = SystemPermissionManager.add((String)"datasource", (String)"administration", null, (int)5700, (boolean)false, DatasourcesServerPlugin.class);
    public static final I18nMessages MSG = new I18nMessages("com.inet.report.plugins.datasources.client.i18n.LanguageResources", DatasourcesServerPlugin.class);
    public static final I18nMessages CONFIG_MSG = new I18nMessages("com.inet.report.plugins.datasources.structure.i18n.ConfigStructure", DatasourcesServerPlugin.class);
    public static final int NEW_DATASOURCES_SCOPE = 7;
    private static final List<Integer> a = Arrays.asList(4, 6);

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("datasource", 4150, new Permission[]{PERMISSION_DATASOURCES}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("usersandgroups", 9254, new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("webapi", 9154, true, new Permission[]{Permission.valueOfExistingOrCreate((String)"webapi.core"), PERMISSION_DATASOURCES}){}, new String[]{"webapi.core"});
        final ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        serverPluginManager.runIfPluginLoaded("help", () -> new Executable(){

            public void execute() {
                com.inet.report.plugins.datasources.server.help.a.b(serverPluginManager);
            }
        });
    }

    public void registerExtension(final ServerPluginManager spm) {
        if (spm.isPluginLoaded("remotegui")) {
            b b2 = new b();
            spm.register(IModule.class, (Object)b2);
            spm.register(PluginServlet.class, (Object)new com.inet.report.plugins.datasources.a(b2.getPath()));
            FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
            combinedFile.add(DatasourcesServerPlugin.class, "client/js/datasources-main-controller.js");
            combinedFile.add(DatasourcesServerPlugin.class, "client/js/datasources-edit-controller.js");
            combinedFile.add(DatasourcesServerPlugin.class, "client/js/factory.js");
            combinedFile.add(DatasourcesServerPlugin.class, "client/js/model.js");
            combinedFile.add(DatasourcesServerPlugin.class, "client/js/renderer.js");
            combinedFile.add(DatasourcesServerPlugin.class, "client/js/renderer-permissions.js");
            combinedFile.add(DatasourcesServerPlugin.class, "client/js/renderer-urlauth.js");
            combinedFile.addMessages(MSG);
            spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 1, "datasources.js", combinedFile));
            if (spm.isPluginLoaded("theme")) {
                spm.register(ThemeResource.class, (Object)new ThemeResource(100, "remotegui", this.getClass().getResource("client/css/datasources.less")));
            }
            combinedFile = new FileCombiner.CombinedFile("text/css", new URL[0]);
            combinedFile.add(DatasourcesServerPlugin.class, "client/css/datasources.css");
            spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", combinedFile));
            FileCombiner.CombinedFile combinedFile2 = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
            combinedFile2.add(DatasourcesServerPlugin.class, "client/datasourcesdetails.html");
            spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "datasourcesdetails.html", combinedFile2));
        }
        if (spm.isPluginLoaded("maintenance")) {
            spm.register(BackupTask.class, (Object)new com.inet.report.plugins.datasources.backup.a());
        }
        if (spm.isPluginLoaded("webapi.core")) {
            new Runnable(){

                @Override
                public void run() {
                    spm.register(WebAPIExtension.class, (Object)new d());
                }
            }.run();
        }
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }

    @Nonnull
    public static Boolean isRestricted(DataSourceConfiguration dsc) {
        return a.contains(dsc.getScope());
    }
}

