/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.DataType;
import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.report.DatabaseConfiguration;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.cassandra.b;
import com.inet.report.cassandra.c;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.shared.utils.WeakValueMap;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@InternalApi
public class CassandraDataFactory
extends BaseDataFactory {
    private static final WeakValueMap<String, c> a = new WeakValueMap(new ConcurrentHashMap());

    @Nonnull
    public String getVersion() {
        return Session.OSS_DRIVER_COORDINATES.getVersion().toString();
    }

    public boolean supportsCommands() {
        return true;
    }

    public Map<String, TableSourceInfo> getTableSourceInfos(Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        c c2 = this.a(ds.getDataSourceConfiguration());
        Metadata metadata = c2.b();
        for (Map.Entry entry : metadata.getKeyspaces().entrySet()) {
            String string;
            String string2 = ((CqlIdentifier)entry.getKey()).asInternal();
            for (Map.Entry entry2 : ((KeyspaceMetadata)entry.getValue()).getTables().entrySet()) {
                string = ((CqlIdentifier)entry2.getKey()).toString();
                hashMap.put(string2 + "." + string, new TableSourceInfo(null, string2, string, 0));
            }
            for (Map.Entry entry2 : ((KeyspaceMetadata)entry.getValue()).getViews().entrySet()) {
                string = ((CqlIdentifier)entry2.getKey()).toString();
                hashMap.put(string2 + "." + string, new TableSourceInfo(null, string2, string, 10));
            }
        }
        return hashMap;
    }

    public List<ColumnInfo> getColumns(TableSource ts) throws ReportException {
        c c2 = this.a(ts.getDatasource().getDataSourceConfiguration());
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        switch (ts.getType()) {
            case 1: {
                Metadata metadata = c2.b();
                String string = ts.getDatabaseIdentifier();
                String[] stringArray = DatabaseUtils.parseSourceName((DatabaseConfiguration)this.getConfiguration(), (String)string);
                String string2 = stringArray[1];
                String string3 = stringArray[2];
                if (string2 == null) {
                    string2 = c2.a();
                }
                if (string2 == null) {
                    throw new ReportException("No keyspace declared for table/view: " + string, 0);
                }
                Optional optional = metadata.getKeyspace(CqlIdentifier.fromInternal((String)string2));
                if (!optional.isPresent()) {
                    throw new ReportException("Keyspace not found: " + string2, 0);
                }
                Optional optional2 = ((KeyspaceMetadata)optional.get()).getTable(CqlIdentifier.fromInternal((String)string3));
                if (!optional2.isPresent() && !(optional2 = ((KeyspaceMetadata)optional.get()).getView(CqlIdentifier.fromInternal((String)string3))).isPresent()) {
                    throw new ReportException("Table or view not found: " + string3, 0);
                }
                RelationMetadata relationMetadata = (RelationMetadata)optional2.get();
                for (ColumnMetadata columnMetadata : relationMetadata.getColumns().values()) {
                    int n = CassandraDataFactory.a(columnMetadata.getType());
                    if (n == -1) continue;
                    arrayList.add(new ColumnInfo(columnMetadata.getName().asInternal(), n));
                }
                return arrayList;
            }
            case 3: {
                String string = ts.getSqlWithPromptFieldValues();
                string = CassandraDataFactory.a(string);
                ResultSet resultSet = c2.b(string);
                for (ColumnDefinition columnDefinition : resultSet.getColumnDefinitions()) {
                    int n = CassandraDataFactory.a(columnDefinition.getType());
                    if (n == -1) continue;
                    arrayList.add(new ColumnInfo(columnDefinition.getName().asInternal(), n));
                }
                return arrayList;
            }
        }
        throw new IllegalStateException("Unsupported TableSource type: " + ts.getType());
    }

    @Nonnull
    private static String a(@Nonnull String string) {
        int n;
        char c2 = '\u0000';
        int n2 = n = string.length();
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t\"'", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n4 = string2.length();
            block8 : switch (string2) {
                case " ": 
                case "\n": 
                case "\r": 
                case "\t": {
                    break;
                }
                case "\"": 
                case "'": {
                    char c3 = string2.charAt(0);
                    if (c2 == '\u0000') {
                        c2 = c3;
                        break;
                    }
                    if (c2 != c3) break;
                    c2 = '\u0000';
                    break;
                }
                default: {
                    if (c2 != '\u0000') break;
                    switch (string2.toUpperCase()) {
                        case "LIMIT": {
                            n2 = n3;
                            break block8;
                        }
                        case "ALLOW": {
                            int n5 = Math.min(n3, n2);
                            return string.substring(0, n5) + "LIMIT 1 " + string.substring(n3, n);
                        }
                    }
                }
            }
            n3 += n4;
        }
        return string.substring(0, n2).trim() + " LIMIT 1";
    }

    private static int a(DataType dataType) {
        switch (dataType.getProtocolCode()) {
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 19: 
            case 20: {
                return 6;
            }
            case 3: {
                return 14;
            }
            case 4: {
                return 8;
            }
            case 1: 
            case 13: {
                return 11;
            }
            case 11: {
                return 15;
            }
            case 18: {
                return 10;
            }
            case 17: {
                return 9;
            }
        }
        return -1;
    }

    public TableData getTableSourceData(TableSource ts) throws ReportException {
        StringBuilder stringBuilder;
        Object object;
        String string = switch (ts.getType()) {
            case 1 -> {
                object = DatabaseUtils.parseSourceName((DatabaseConfiguration)this.getConfiguration(), (String)ts.getDatabaseIdentifier());
                stringBuilder = new StringBuilder("SELECT * FROM ");
                for (int var5_4 = 0; var5_4 < ((Object)object).length; ++var5_4) {
                    Object var6_6 = object[var5_4];
                    if (var6_6 == null) continue;
                    stringBuilder.append(CqlIdentifier.fromInternal((String)var6_6).asCql(true));
                    if (var5_4 >= ((Object)object).length - 1) continue;
                    stringBuilder.append('.');
                }
                yield stringBuilder.toString();
            }
            case 3 -> ts.getSqlWithPromptFieldValues();
            default -> throw new IllegalStateException("Unsupported TableSource type: " + ts.getType());
        };
        object = this.a(ts.getDatasource().getDataSourceConfiguration());
        stringBuilder = ((c)object).b(string);
        ColumnDefinitions columnDefinitions = stringBuilder.getColumnDefinitions();
        int n = columnDefinitions.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            ColumnDefinition columnDefinition = columnDefinitions.get(i);
            stringArray[i] = columnDefinition.getName().asInternal();
        }
        return new TableData((java.sql.ResultSet)((Object)new b(stringArray, (ResultSet)stringBuilder, (c)object)));
    }

    @Nonnull
    c a(@Nonnull DataSourceConfiguration dataSourceConfiguration) {
        String string;
        c c2;
        int n;
        String string2;
        Objects.requireNonNull(dataSourceConfiguration, "DataSourceConfiguration is null");
        StringBuilder stringBuilder = new StringBuilder();
        CqlSessionBuilder cqlSessionBuilder = CqlSession.builder();
        cqlSessionBuilder.withApplicationName(ApplicationDescription.get().getApplicationName());
        String string3 = dataSourceConfiguration.getUser();
        String string4 = dataSourceConfiguration.getPassword();
        if (!StringFunctions.isEmpty((String)string3) || !StringFunctions.isEmpty((String)string4)) {
            cqlSessionBuilder.withAuthCredentials(string3, string4);
            stringBuilder.append(string3).append('|').append(string4);
        }
        if (!StringFunctions.isEmpty((String)(string2 = dataSourceConfiguration.getProperty("keyspace")))) {
            cqlSessionBuilder.withKeyspace(CqlIdentifier.fromInternal((String)string2));
            stringBuilder.append('|').append(string2);
        }
        try {
            n = Integer.parseInt(dataSourceConfiguration.getProperty("port"));
        }
        catch (Throwable throwable) {
            n = 9042;
        }
        stringBuilder.append('|').append(n);
        String string5 = dataSourceConfiguration.getProperty("hosts");
        stringBuilder.append('|').append(string5);
        for (String string6 : string5.split("[,;]")) {
            if ((string6 = string6.trim()).length() == 0) continue;
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string6, n);
            cqlSessionBuilder.addContactPoint(inetSocketAddress);
        }
        String string7 = dataSourceConfiguration.getProperty("datacenter");
        if (!StringFunctions.isEmpty((String)string7)) {
            cqlSessionBuilder.withLocalDatacenter(string7);
            stringBuilder.append('|').append(string7);
        }
        if ((c2 = (c)a.get((Object)(string = stringBuilder.toString()))) == null) {
            c2 = new c(cqlSessionBuilder);
            a.put((Object)string, (Object)c2);
        }
        return c2;
    }
}

