/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.Field;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.FieldMapping;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportListRequestData;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportListResponseData;
import com.inet.helpdesk.plugins.dataimport.server.data.DeviceImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.UserImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import com.inet.helpdesk.plugins.dataimport.server.handler.DeviceImportHelper;
import com.inet.helpdesk.plugins.dataimport.server.handler.FieldDescription;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class GetImportListHandler
extends AbstractDataImportHandler<DataImportListRequestData, DataImportListResponseData> {
    public String getMethodName() {
        return "dataimport_getimportlist";
    }

    @Override
    public DataImportListResponseData invoke(final DataImportConnector importConnector, DataImportListRequestData data) throws IOException, ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        final DataImportListResponseData response = new DataImportListResponseData();
        Configuration current = ConfigurationManager.getInstance().getCurrent();
        response.setCurrentConfigName(current.getName());
        response.setCurrentConfigScope(current.getScope());
        ServerInitializerStatus ssStatus = (ServerInitializerStatus)spm.getSingleInstance(ServerInitializerStatus.class);
        VetoStatus currentVeto = ssStatus.getCurrentVeto();
        if (currentVeto != null) {
            String initializingMessage = currentVeto.getMessage();
            response.setServerInitializingMessage(initializingMessage);
            return response;
        }
        final ArrayList<DataImportEntry> entries = new ArrayList<DataImportEntry>();
        spm.runIfPluginLoaded("inventory", () -> new Executable(){

            public void execute() {
                try {
                    DeviceImportConfigInfoMap deviceImportConfigInfoMap = importConnector.getDeviceImports();
                    for (Map.Entry entry : deviceImportConfigInfoMap.entrySet()) {
                        String name = (String)entry.getKey();
                        DeviceImportConfigInfo dici = (DeviceImportConfigInfo)entry.getValue();
                        DeviceImportEntry deviceImportEntry = DeviceImportHelper.convertToJsonModel(name, dici);
                        deviceImportEntry.setJobs(importConnector.getJobs(dici.getUid()));
                        entries.add(deviceImportEntry);
                    }
                }
                catch (RuntimeException e) {
                    throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("deviceimport.cantgetdevices", new Object[0]), (Throwable)e);
                }
            }
        });
        UserImportConfigInfoMap userImportConfigInfoMap = importConnector.getUserImports();
        for (Map.Entry entry : userImportConfigInfoMap.entrySet()) {
            String name = (String)entry.getKey();
            UserImportConfigInfo uici = (UserImportConfigInfo)entry.getValue();
            if (uici.getFieldMapping() == null) {
                ArrayList fmeList = FieldMapping.createFieldList((String)uici.getSelektionList());
                uici.setFieldMapping((List)fmeList);
            }
            UserImportEntry userImportEntry = this.convertToJsonModel(name, uici);
            userImportEntry.setJobs(importConnector.getJobs(uici.getUid()));
            entries.add(userImportEntry);
        }
        Collections.sort(entries);
        response.setDataImportList(entries);
        spm.runIfPluginLoaded("inventory", () -> new Executable(){

            public void execute() {
                Map<Integer, List<FieldDescription>> deviceFieldsByTypeId = DeviceImportHelper.getDeviceFieldsByTypeId();
                response.setMappingKeysDevice(deviceFieldsByTypeId);
            }
        });
        if (data.isInitialRequest()) {
            ArrayList<LocalizedKey> mappingKeysUser = new ArrayList<LocalizedKey>();
            for (com.inet.helpdesk.shared.model.Field field : DataImportConnector.USER_IMPORT_FIELDS) {
                Field apiField = HDFieldLocator.getFieldForOldDbField((com.inet.helpdesk.shared.model.Field)field);
                if (apiField != null) {
                    mappingKeysUser.add(new LocalizedKey(field.getKey(), apiField.getLabel()));
                    continue;
                }
                mappingKeysUser.add(new LocalizedKey(field.getKey(), field.getKey()));
            }
            mappingKeysUser.add(1, new LocalizedKey("SecondUsername", "de".equals(ClientLocale.getThreadLocale().getLanguage()) ? "Alternatives Login" : "Alternative login"));
            response.setMappingKeysUser(mappingKeysUser);
        }
        ArrayList connections = importConnector.getConnections();
        Collections.sort(connections, new Comparator<ConnectionEntry>(){

            @Override
            public int compare(ConnectionEntry o1, ConnectionEntry o2) {
                int compare = o1.getConnectionType().ordinal() - o2.getConnectionType().ordinal();
                if (compare == 0) {
                    return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
                }
                return 0;
            }
        });
        response.setConnectionList(connections);
        return response;
    }
}

