/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.helpdesk.config.FieldMappingEntry;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.SaveDataResponseData;
import com.inet.helpdesk.plugins.dataimport.server.data.UserImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class SaveUserImportHandler
extends AbstractDataImportHandler<UserImportEntry, SaveDataResponseData> {
    public String getMethodName() {
        return "dataimport_saveuserimport";
    }

    @Override
    public SaveDataResponseData invoke(DataImportConnector importConnector, UserImportEntry data) throws IOException, ServerDataException {
        if (data.getName() == null || data.getName().isEmpty()) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.noname", new Object[]{data.getName()}));
        }
        if (data.getConnection() == null) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.noconnection", new Object[0]));
        }
        if (StringFunctions.isEmpty((String)data.getTable())) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.nousertable", new Object[0]));
        }
        if (this.hasInvalidSchedule(data.getSchedule())) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.schedule.invalid", new Object[]{data.getName()}));
        }
        UserImportConfigInfoMap userImports = importConnector.getUserImports();
        String id = data.getId();
        for (String name : userImports.keySet()) {
            if (!name.equals(data.getName()) || id != null && id.equals(((UserImportConfigInfo)userImports.get((Object)name)).getUid())) continue;
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.userimport.nameexists", new Object[]{data.getName()}));
        }
        UserImportConfigInfo uici = this.convertUserImport(data);
        if (this.hasNoUsernameColumn(uici)) {
            throw new ClientMessageException(HelpDeskDataImportPlugin.MSG.getMsg("save.dataimport.nousernamecolumn", new Object[]{data.getName()}));
        }
        if (id != null) {
            Iterator iterator = userImports.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object currentID = ((UserImportConfigInfo)entry.getValue()).getUid();
                if (currentID == null) {
                    currentID = DataImportEntry.TYPE.USER.name() + "." + (String)entry.getKey();
                }
                if (!id.equals(currentID)) continue;
                iterator.remove();
                break;
            }
        }
        userImports.put((Object)data.getName(), (Object)uici);
        importConnector.saveUserImports(userImports);
        return new SaveDataResponseData(uici.getUid());
    }

    private boolean hasNoUsernameColumn(UserImportConfigInfo data) {
        FieldMappingEntry fme = (FieldMappingEntry)data.getFieldMapping().get(0);
        return fme.getSelectedColumn() == null || fme.getSelectedColumn().length() == 0;
    }
}

