/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.model.dataimport.ConnectionEntry;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import com.inet.helpdesk.plugins.dataimport.server.handler.FieldDescription;
import java.util.ArrayList;

@JsonData
public abstract class DataImportEntry
implements Comparable<DataImportEntry> {
    private String id;
    private ConnectionEntry connection;
    private TYPE type;
    private String name;
    private ArrayList<MappingEntry> mapping = new ArrayList();
    private String table;
    private DataImportSchedule schedule;
    private boolean deletePermission;
    private ArrayList<DataImportJob> jobs;

    protected DataImportEntry() {
    }

    public DataImportEntry(TYPE type, String name) {
        this.type = type;
        this.name = name;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setMapping(ArrayList<MappingEntry> mapping) {
        this.mapping = mapping;
    }

    public ArrayList<MappingEntry> getMapping() {
        return this.mapping;
    }

    public boolean isDeletePermission() {
        return this.deletePermission;
    }

    public void setDeletePermission(boolean deletePermission) {
        this.deletePermission = deletePermission;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(DataImportEntry o) {
        if (this.type == TYPE.USER) {
            if (o.type == TYPE.DEVICE) {
                return -1;
            }
        } else if (o.type == TYPE.USER) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public DataImportSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(DataImportSchedule schedule) {
        this.schedule = schedule;
    }

    public ConnectionEntry getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionEntry connection) {
        this.connection = connection;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id == null) {
            id = this.type.name() + "." + this.name;
        }
        this.id = id;
    }

    public void setJobs(ArrayList<DataImportJob> jobs) {
        this.jobs = jobs;
    }

    public ArrayList<DataImportJob> getJobs() {
        return this.jobs;
    }

    public static enum TYPE {
        USER,
        DEVICE;

    }

    @JsonData
    public static class MappingEntry {
        private FieldDescription definedColumn;
        private String userColumn;

        private MappingEntry() {
        }

        public MappingEntry(FieldDescription definedColumn, String userColumn) {
            this.definedColumn = definedColumn;
            this.userColumn = userColumn;
        }

        public FieldDescription getDefinedColumn() {
            return this.definedColumn;
        }

        public String getUserColumn() {
            return this.userColumn;
        }
    }
}

