/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.field.ConfigurableField;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.server.data.DataImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.DeviceImportEntry;
import com.inet.helpdesk.plugins.dataimport.server.data.ExamplesResponseData;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import com.inet.helpdesk.plugins.dataimport.server.handler.DeviceImportHelper;
import com.inet.helpdesk.plugins.dataimport.server.handler.FieldDescription;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.abstracts.AssetFieldDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GetDeviceExamplesHandler
extends AbstractDataImportHandler<DeviceImportEntry, ExamplesResponseData> {
    public String getMethodName() {
        return "dataimport_getdeviceexamples";
    }

    @Override
    public ExamplesResponseData invoke(DataImportConnector importConnector, DeviceImportEntry data) throws ServerDataException {
        Map<String, Integer> priority = DeviceImportHelper.getDeviceFieldDefinitions().stream().collect(Collectors.toMap(AssetFieldDefinition::getLabel, ConfigurableField::getPriority));
        DeviceImportConfigInfo dici = DeviceImportHelper.convertDeviceImport(data);
        List samples = importConnector.getExamples(dici, data.getName());
        List<Object> examples = new ArrayList();
        if (samples != null) {
            examples = samples.stream().limit(6L).map(sample -> this.createSortedMappingEntryList((Map<String, String>)sample, priority)).collect(Collectors.toList());
        }
        ExamplesResponseData response = new ExamplesResponseData();
        response.setExamples(new ArrayList<ArrayList<DataImportEntry.MappingEntry>>(examples));
        return response;
    }

    private ArrayList<DataImportEntry.MappingEntry> createSortedMappingEntryList(Map<String, String> sample, Map<String, Integer> priority) {
        ArrayList entry = sample.keySet().stream().map(key -> new DataImportEntry.MappingEntry(new FieldDescription((String)key, (String)key), (String)sample.get(key))).sorted((o1, o2) -> this.compareMappingEntries((DataImportEntry.MappingEntry)o1, (DataImportEntry.MappingEntry)o2, priority)).collect(Collectors.toCollection(ArrayList::new));
        return entry;
    }

    private int compareMappingEntries(DataImportEntry.MappingEntry o1, DataImportEntry.MappingEntry o2, Map<String, Integer> priority) {
        Integer p2;
        Integer p1 = priority.getOrDefault(o1.getDefinedColumn().getKey(), 100000);
        int compareTo = p1.compareTo(p2 = priority.getOrDefault(o2.getDefinedColumn().getKey(), 100000));
        return compareTo != 0 ? compareTo : o1.getDefinedColumn().getKey().compareToIgnoreCase(o2.getDefinedColumn().getKey());
    }
}

