/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.datacare;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTaskParameter;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries.UserPreviewEntry;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserImportDataCareTask
implements DataCareTask {
    @Nonnull
    public String getExtensionName() {
        return "datacare.userimport";
    }

    public String getTitle() {
        return HelpDeskDataImportPlugin.MSG.getMsg("datacare.userimport.title", new Object[0]);
    }

    public String getDescription() {
        return HelpDeskDataImportPlugin.MSG.getMsg("datacare.userimport.description", new Object[0]);
    }

    public int getPriority() {
        return 110;
    }

    public DataCareTaskParameter getParameter() {
        LocalizedKey key = new LocalizedKey("userimportkey", HelpDeskDataImportPlugin.MSG.getMsg("datacare.userimport.parameter.userimportkey", new Object[0]));
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        DataImportConnector connector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        UserImportConfigInfoMap userImports = connector.getUserImports();
        HashSet importNames = null;
        try {
            importNames = connector.getUserImportNamesFromDatabase();
        }
        catch (ServerDataException sde) {
            HelpDeskDataImportPlugin.LOGGER.error((Throwable)sde);
        }
        if (importNames != null) {
            Iterator iterator = importNames.iterator();
            while (iterator.hasNext()) {
                String impName;
                String pKey = impName = (String)iterator.next();
                String pLabel = null;
                for (Map.Entry entry : userImports.entrySet()) {
                    if (!impName.equals(((UserImportConfigInfo)entry.getValue()).getUid())) continue;
                    pLabel = (String)entry.getKey();
                    break;
                }
                if (pLabel == null) {
                    pLabel = HelpDeskDataImportPlugin.MSG.getMsg("datacare.userimport.parameter.nolabel", new Object[0]);
                }
                values.add(new LocalizedKey(pKey, pLabel));
            }
        }
        return new DataCareTaskParameter(key, values);
    }

    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        MaintenanceConnector connector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
        String importName = parameters.get("userimportkey");
        MaintenanceConnector.EntriesToDelete unrelatedUsers = connector.findUnrelatedUsers(importName);
        ArrayList<UserPreviewEntry> list = new ArrayList<UserPreviewEntry>();
        for (MaintenanceConnector.UnrelatedUser user : unrelatedUsers.getExemplaryEntries()) {
            list.add(new UserPreviewEntry().from(user));
        }
        DataCarePreview preview = new DataCarePreview();
        int entriesCount = unrelatedUsers.getFoundEntriesCount();
        preview.setPreviewMsg(HelpDeskDataImportPlugin.MSG.getMsg(entriesCount > 0 ? "datacare.userimport.preview" : "datacare.userimport.nopreview", new Object[]{entriesCount, unrelatedUsers.isFoundMore() ? 1 : 0}));
        preview.setExamples(list);
        return preview;
    }

    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        MaintenanceConnector connector = (MaintenanceConnector)ServerPluginManager.getInstance().getSingleInstance(MaintenanceConnector.class);
        String importName = parameters.get("userimportkey");
        connector.deleteUnrelatedUsers(importName);
        return null;
    }
}

