/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.datacare;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.maintenance.AssetPreviewEntry;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetView;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTaskParameter;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeviceImportDataCareTask
implements DataCareTask {
    @Nonnull
    public String getExtensionName() {
        return "datacare.deviceimport";
    }

    public String getTitle() {
        return HelpDeskDataImportPlugin.MSG.getMsg("datacare.deviceimport.title", new Object[0]);
    }

    public String getDescription() {
        return HelpDeskDataImportPlugin.MSG.getMsg("datacare.deviceimport.description", new Object[0]);
    }

    public int getPriority() {
        return 120;
    }

    public DataCareTaskParameter getParameter() {
        LocalizedKey key = new LocalizedKey("deviceimportkey", HelpDeskDataImportPlugin.MSG.getMsg("datacare.deviceimport.parameter.deviceimportkey", new Object[0]));
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        DataImportConnector connector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        DeviceImportConfigInfoMap deviceImports = connector.getDeviceImports();
        HashSet importNames = null;
        try {
            importNames = connector.getDeviceImportNamesFromDatabase();
        }
        catch (ServerDataException sde) {
            HelpDeskDataImportPlugin.LOGGER.error((Throwable)sde);
        }
        if (importNames != null) {
            Iterator sde = importNames.iterator();
            while (sde.hasNext()) {
                String impName;
                String pKey = impName = (String)sde.next();
                Object pLabel = null;
                for (Map.Entry entry : deviceImports.entrySet()) {
                    if (!impName.equals(entry.getKey())) continue;
                    pLabel = (String)entry.getKey();
                    int gerTyp = ((DeviceImportConfigInfo)entry.getValue()).getGerTyp();
                    AssetTypeVO assetType = (AssetTypeVO)AssetTypeManager.getInstance().get(gerTyp);
                    if (assetType != null) {
                        pLabel = (String)pLabel + " (" + assetType.getDisplayValue() + ")";
                    }
                    pKey = ((DeviceImportConfigInfo)entry.getValue()).getUid();
                    break;
                }
                if (pLabel == null) {
                    pLabel = HelpDeskDataImportPlugin.MSG.getMsg("datacare.deviceimport.parameter.nolabel", new Object[0]);
                }
                values.add(new LocalizedKey(pKey, (String)pLabel));
            }
        }
        DataCareTaskParameter parameter = new DataCareTaskParameter(key, values);
        return parameter;
    }

    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        DataImportConnector connector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        String importName = parameters.get("deviceimportkey");
        DeviceImportConfigInfoMap deviceImports = connector.getDeviceImports();
        for (Map.Entry entry : deviceImports.entrySet()) {
            if (!((DeviceImportConfigInfo)entry.getValue()).getUid().equals(importName)) continue;
            importName = (String)entry.getKey();
            break;
        }
        SearchCommand command = new SearchCommand(new SearchExpression[]{new SearchCondition(AssetFields.FIELD_IMPORT_NAME.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)importName)});
        AssetManager manager = this.assetManager();
        Set devices = manager.getSearchEngine().simpleSearch(command);
        ArrayList<AssetPreviewEntry> list = new ArrayList<AssetPreviewEntry>();
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            for (GUID assetID : devices) {
                list.add(AssetPreviewEntry.generateEntryFromAsset((AssetView)manager.getAsset(assetID)));
                if (list.size() != 6) continue;
                break;
            }
        }
        DataCarePreview preview = new DataCarePreview();
        int entriesCount = devices.size();
        preview.setPreviewMsg(HelpDeskDataImportPlugin.MSG.getMsg(entriesCount > 0 ? "datacare.deviceimport.preview" : "datacare.deviceimport.nopreview", new Object[]{entriesCount}));
        preview.setExamples(list);
        return preview;
    }

    protected AssetManager assetManager() {
        AssetManager manager = AssetManager.getInstance();
        return manager;
    }

    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        DataImportConnector connector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        String importName = parameters.get("deviceimportkey");
        DeviceImportConfigInfoMap deviceImports = connector.getDeviceImports();
        for (Map.Entry entry : deviceImports.entrySet()) {
            if (!((DeviceImportConfigInfo)entry.getValue()).getUid().equals(importName)) continue;
            importName = (String)entry.getKey();
            break;
        }
        connector.deleteDevicesFromImport(importName);
        return null;
    }
}

