/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.backup;

import com.inet.config.Configuration;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.plugins.dataimport.HelpDeskDataImportPlugin;
import com.inet.lib.json.Json;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.maintenance.api.backup.tasks.BackupConfigurationKey;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

public class DataImportBackupTask
implements BackupTask,
BackupConfigurationKey {
    public String getKey() {
        return "helpdesk.dataimport";
    }

    public String getTitle() {
        return HelpDeskDataImportPlugin.MSG.getMsg("title", new Object[0]);
    }

    public String getDescription() {
        return HelpDeskDataImportPlugin.MSG.getMsg("dataimport.backupsettings.description", new Object[0]);
    }

    public URL getIconURL() {
        return DataImportBackupTask.class.getResource("/com/inet/helpdesk/plugins/dataimport/resources/img/dataimport_32.png");
    }

    public Set<String> getKeysToBackup() {
        HashSet<String> keys = new HashSet<String>();
        keys.add(HDConfigKeys.USER_IMPORT_CONFIGS.getKey());
        keys.add(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey());
        return keys;
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, BackupContentInformation contentInformation, ProgressUpdater progressUpdater) throws Throwable {
        progressUpdater.updateProgress(0);
        Configuration currentConfiguration = MaintenanceHelper.getCurrentConfiguration();
        String user = currentConfiguration.get(HDConfigKeys.USER_IMPORT_CONFIGS.getKey());
        String device = currentConfiguration.get(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey());
        progressUpdater.updateProgress(15);
        Properties properties = new Properties();
        if (user != null) {
            properties.setProperty(HDConfigKeys.USER_IMPORT_CONFIGS.getKey(), user);
        }
        if (device != null) {
            properties.setProperty(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey(), device);
        }
        progressUpdater.updateProgress(30);
        int userCount = 0;
        int deviceCount = 0;
        if (user != null && user.startsWith("{")) {
            userCount = ((UserImportConfigInfoMap)new Json().fromJson(user, UserImportConfigInfoMap.class)).size();
        }
        if (device != null && device.startsWith("{")) {
            deviceCount = ((DeviceImportConfigInfoMap)new Json().fromJson(device, DeviceImportConfigInfoMap.class)).size();
        }
        progressUpdater.updateProgress(70);
        try (FileOutputStream out = new FileOutputStream(taskPath.resolve("dataimport.properties").toFile());){
            properties.store(out, null);
        }
        contentInformation.addTaskDetails(this.getKey(), HelpDeskDataImportPlugin.MSG.getMsg("dataimport.backupsettings.taskdetail.userimport", new Object[]{userCount}));
        contentInformation.addTaskDetails(this.getKey(), HelpDeskDataImportPlugin.MSG.getMsg("dataimport.backupsettings.taskdetail.deviceimport", new Object[]{deviceCount}));
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        progressUpdater.updateProgress(0);
        File propFile = taskPath.resolve("dataimport.properties").toFile();
        Properties properties = new Properties();
        try (FileInputStream inStream = new FileInputStream(propFile);){
            properties.load(inStream);
        }
        progressUpdater.updateProgress(60);
        Configuration currentConfiguration = MaintenanceHelper.getCurrentConfiguration();
        String property = properties.getProperty(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey());
        currentConfiguration.put(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey(), property);
        progressUpdater.updateProgress(80);
        property = properties.getProperty(HDConfigKeys.USER_IMPORT_CONFIGS.getKey());
        currentConfiguration.put(HDConfigKeys.USER_IMPORT_CONFIGS.getKey(), property);
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

