/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.server.data.DeviceType;
import com.inet.helpdesk.plugins.dataimport.server.data.DeviceTypesResponseData;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.field.type.AssetTypeVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GetDeviceTypesHandler
extends AbstractDataImportHandler<Void, DeviceTypesResponseData> {
    public String getMethodName() {
        return "dataimport_getdevicetypes";
    }

    @Override
    public DeviceTypesResponseData invoke(DataImportConnector importConnector, Void data) throws IOException, ServerDataException {
        DeviceTypesResponseData response = new DeviceTypesResponseData();
        List types = AssetTypeManager.getInstance().getAll(true);
        ArrayList<DeviceType> deviceTypes = new ArrayList<DeviceType>();
        for (AssetTypeVO type : types) {
            deviceTypes.add(new DeviceType(type.getId(), type.getDisplayValue(), type.getSymbol()));
        }
        deviceTypes.sort((o1, o2) -> {
            String displayName1 = o1.getDisplayName();
            String displayName2 = o2.getDisplayName();
            displayName1 = displayName1 == null ? "" : displayName1;
            displayName2 = displayName2 == null ? "" : displayName2;
            return String.CASE_INSENSITIVE_ORDER.compare(displayName1, displayName2);
        });
        response.setDeviceTypes(deviceTypes);
        return response;
    }
}

