/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.dataimport.server.handler;

import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.dataimport.server.data.ColumnsRequestData;
import com.inet.helpdesk.plugins.dataimport.server.data.ColumnsResponseData;
import com.inet.helpdesk.plugins.dataimport.server.handler.AbstractDataImportHandler;
import java.util.ArrayList;
import java.util.Collections;

public class GetColumnsHandler
extends AbstractDataImportHandler<ColumnsRequestData, ColumnsResponseData> {
    public String getMethodName() {
        return "dataimport_getcolumns";
    }

    @Override
    public ColumnsResponseData invoke(DataImportConnector importConnector, ColumnsRequestData data) throws ServerDataException {
        ColumnsResponseData response = new ColumnsResponseData();
        DataImportConnector.ColumnsOrAttributes coa = importConnector.getColumns(data.getConnection(), data.getTable(), data.isUseUserSyntax(), data.getUserSyntax());
        ArrayList entries = coa.getColumnsOrAttributes();
        Collections.sort(entries, String.CASE_INSENSITIVE_ORDER);
        response.setColumnList(entries);
        response.setPictureAttribute(coa.containsPicturAttribute());
        response.setHideFromAddressListsAttribute(coa.containsHideFromAddressListsAttribute());
        return response;
    }
}

