/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.teams;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.webapi.channels.b;
import com.inet.cowork.server.webapi.teams.TeamCreateRequestData;
import com.inet.cowork.server.webapi.teams.TeamGUIDResponseData;
import com.inet.cowork.server.webapi.teams.c;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Admin Teams", description="Administrative team management operations")
public class a
extends c {
    public a() {
        super("team");
        this.registerRequestHandler((RequestHandlerBase)new b());
    }

    @Override
    public String getHelpPageKey() {
        return "webapi.cowork.admin.teams.id";
    }

    @Override
    @Operation(summary="Manage specific administrative team", description="Get, update, or delete a specific administrative team by its GUID. Requires CoWork Admin permission.", responses={@ApiResponse(responseCode="200", description="Team details retrieved or updated successfully", content={@Content(schema=@Schema(implementation=TeamGUIDResponseData.class))}), @ApiResponse(responseCode="204", description="Team deleted successfully"), @ApiResponse(responseCode="400", description="Invalid team update data or deletion request"), @ApiResponse(responseCode="403", description="Access denied - user is not a team admin or team is predefined"), @ApiResponse(responseCode="404", description="Team not found")})
    public TeamGUIDResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable TeamCreateRequestData teamCreateRequestData, @Nullable GUID gUID, List<String> list, boolean bl) throws IOException {
        boolean bl2 = "DELETE".equalsIgnoreCase(httpServletRequest.getMethod());
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        CoWorkTeam coWorkTeam = coWorkManager.getTeam(gUID);
        if (coWorkTeam == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Team is not available.");
            return null;
        }
        if (!coWorkTeam.isAdmin() || coWorkTeam.isPredefined()) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"User is not a team admin.");
            return null;
        }
        if (bl2) {
            if (list.size() > 0) {
                throw new ClientMessageException("Team deletion requested, but this was probably the wrong handler. You also sent the following tokens along: " + String.join((CharSequence)"/", list));
            }
            if (!bl) {
                coWorkManager.deleteTeam(coWorkTeam.getId());
            }
            httpServletResponse.setStatus(204);
            return null;
        }
        coWorkTeam = this.a(httpServletRequest, coWorkTeam, teamCreateRequestData, bl);
        return TeamGUIDResponseData.from(coWorkTeam, true);
    }

    private CoWorkTeam a(HttpServletRequest httpServletRequest, CoWorkTeam coWorkTeam, TeamCreateRequestData teamCreateRequestData, boolean bl) {
        if (teamCreateRequestData == null) {
            if (this.isMethodAllowedForData(httpServletRequest)) {
                throw new ClientMessageException("Team update requested, but no data sent.");
            }
            return coWorkTeam;
        }
        CoWorkTeam coWorkTeam2 = CoWorkTeam.create(coWorkTeam.getId(), teamCreateRequestData.getDisplayName(), teamCreateRequestData.getMemberUserIDs(), teamCreateRequestData.getMemberGroupIDs(), teamCreateRequestData.getAdminUserIDs(), teamCreateRequestData.getAdminGroupIDs());
        if (!bl) {
            CoWorkManager.getInstance().saveTeam(coWorkTeam2);
        }
        return coWorkTeam2;
    }

    @Override
    @Operation(summary="Manage specific administrative team", description="Get, update, or delete a specific administrative team by its GUID. Requires CoWork Admin permission.", responses={@ApiResponse(responseCode="200", description="Team details retrieved or updated successfully", content={@Content(schema=@Schema(implementation=TeamGUIDResponseData.class))}), @ApiResponse(responseCode="204", description="Team deleted successfully"), @ApiResponse(responseCode="400", description="Invalid team update data or deletion request"), @ApiResponse(responseCode="403", description="Access denied - user is not a team admin or team is predefined"), @ApiResponse(responseCode="404", description="Team not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, List list, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (TeamCreateRequestData)object, (GUID)object2, list, bl);
    }
}

