/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.persistence;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.eventlog.a;
import com.inet.cowork.server.persistence.b;
import com.inet.id.GUID;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
extends b {
    private final Map<GUID, CoWorkChannel> aT = new ConcurrentHashMap<GUID, CoWorkChannel>();
    private final Map<GUID, Map<GUID, CoWorkChannel>> aU = new ConcurrentHashMap<GUID, Map<GUID, CoWorkChannel>>();
    private final PersistenceEntry aJ;

    public c() {
        this(Persistence.getInstance().resolve("cowork/channel"));
    }

    c(@Nonnull PersistenceEntry persistenceEntry2) {
        super("MUC", 0);
        this.aJ = persistenceEntry2;
        persistenceEntry2.getChildren().forEach(persistenceEntry -> {
            CoWorkChannel coWorkChannel = (CoWorkChannel)this.a((PersistenceEntry)persistenceEntry, new Type[]{CoWorkChannel.class});
            if (coWorkChannel != null) {
                this.b(coWorkChannel);
            }
        });
    }

    public void r() {
        this.aJ.getChildren().forEach(persistenceEntry -> this.y(GUID.valueOf((String)persistenceEntry.getName())));
    }

    public void y(GUID gUID) {
        try (ServerLock serverLock = ThreadUtils.getReadLock((Object)gUID);){
            PersistenceEntry persistenceEntry = this.aJ.resolve(gUID.toString());
            CoWorkChannel coWorkChannel = (CoWorkChannel)this.a(persistenceEntry, new Type[]{CoWorkChannel.class});
            if (coWorkChannel != null) {
                this.b(coWorkChannel);
            } else {
                coWorkChannel = this.aT.get(gUID);
                if (coWorkChannel != null) {
                    GUID gUID2 = coWorkChannel.getTeamId();
                    Map<GUID, CoWorkChannel> map = this.aU.get(gUID2);
                    if (map != null) {
                        map.remove(gUID);
                        if (map.isEmpty()) {
                            this.aU.remove(gUID2);
                        }
                    }
                    this.aT.remove(gUID);
                }
            }
        }
    }

    private void b(@Nonnull CoWorkChannel coWorkChannel) {
        GUID gUID = coWorkChannel.getTeamId();
        Map<GUID, CoWorkChannel> map = this.aU.get(gUID);
        if (map == null) {
            map = new ConcurrentHashMap<GUID, CoWorkChannel>();
            this.aU.put(gUID, map);
        }
        GUID gUID2 = coWorkChannel.getId();
        map.put(gUID2, coWorkChannel);
        this.aT.put(gUID2, coWorkChannel);
    }

    public CoWorkChannel getChannel(GUID channelId) {
        return this.aT.get(channelId);
    }

    public List<CoWorkChannel> getAllChannelsInTeam(GUID teamId) {
        Map<GUID, CoWorkChannel> map = this.aU.get(teamId);
        if (map != null) {
            return new ArrayList<CoWorkChannel>(map.values());
        }
        return Collections.emptyList();
    }

    public void saveChannel(@Nonnull CoWorkChannel channel) {
        GUID gUID = channel.getId();
        this.y(gUID);
        try (ServerLock serverLock = ThreadUtils.getWriteLock((Object)gUID);){
            PersistenceEntry persistenceEntry = this.aJ.resolve(gUID.toString());
            CoWorkChannel coWorkChannel = this.aT.get(gUID);
            if (coWorkChannel == null || !coWorkChannel.equals(channel)) {
                this.a(persistenceEntry, channel);
                this.b(channel);
                Object object = channel.getDisplayName();
                GUID gUID2 = channel.getTeamId();
                CoWorkTeam coWorkTeam = CoWorkManager.getInstance().getTeam(gUID2);
                if (coWorkTeam != null) {
                    object = coWorkTeam.getDisplayName() + " - " + (String)object;
                }
                if (coWorkChannel != null) {
                    List<String> list = this.d(coWorkChannel, channel);
                    for (String string : list) {
                        a.aC.a(gUID.toString(), (String)object, string);
                    }
                } else {
                    a.aB.a(gUID.toString(), (String)object, null);
                }
            }
        }
    }

    @Nonnull
    private List<String> d(@Nonnull CoWorkChannel coWorkChannel, @Nonnull CoWorkChannel coWorkChannel2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Objects.equals(coWorkChannel.getDisplayName(), coWorkChannel2.getDisplayName())) {
            arrayList.add("Name: " + coWorkChannel.getDisplayName() + " -> " + coWorkChannel2.getDisplayName());
        }
        if (!Objects.equals(coWorkChannel.getDescription(), coWorkChannel2.getDescription())) {
            arrayList.add("Description: " + (coWorkChannel.getDescription() == null ? "" : coWorkChannel.getDescription()) + " -> " + (coWorkChannel2.getDescription() == null ? "" : coWorkChannel2.getDescription()));
        }
        if (coWorkChannel.isMembersInherited() != coWorkChannel2.isMembersInherited()) {
            arrayList.add("Member Inheritance: " + coWorkChannel.isMembersInherited() + " -> " + coWorkChannel2.isMembersInherited());
        }
        if (!Arrays.equals(coWorkChannel.getIcon(), coWorkChannel2.getIcon())) {
            arrayList.add("Icon changed");
        }
        this.a(arrayList, coWorkChannel.getMemberGroupIds(), coWorkChannel2.getMemberGroupIds(), "Member Group", true);
        this.a(arrayList, coWorkChannel.getMemberUserIds(), coWorkChannel2.getMemberUserIds(), "Member User", false);
        return arrayList;
    }

    private void a(@Nonnull List<String> list, @Nullable Set<GUID> set, @Nullable Set<GUID> set2, String string, boolean bl) {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        if (set != null) {
            hashSet.addAll(set);
        }
        HashSet<GUID> hashSet2 = new HashSet<GUID>();
        if (set2 != null) {
            hashSet2.addAll(set2);
        }
        if (Objects.equals(hashSet, hashSet2)) {
            return;
        }
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet.removeIf(gUID -> hashSet2.contains(gUID));
        hashSet2.removeIf(gUID -> hashSet3.contains(gUID));
        hashSet.forEach(gUID -> {
            if (bl) {
                UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
                if (userGroupInfo != null) {
                    list.add("Removed " + string + ": " + userGroupInfo.getDisplayName());
                }
            } else {
                UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
                if (userAccount != null) {
                    list.add("Removed " + string + ": " + userAccount.getDisplayName());
                }
            }
        });
        hashSet2.forEach(gUID -> {
            if (bl) {
                UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
                if (userGroupInfo != null) {
                    list.add("Added " + string + ": " + userGroupInfo.getDisplayName());
                }
            } else {
                UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
                if (userAccount != null) {
                    list.add("Added " + string + ": " + userAccount.getDisplayName());
                }
            }
        });
    }

    public void deleteChannel(GUID teamId, GUID channelId) {
        try (ServerLock serverLock = ThreadUtils.getWriteLock((Object)channelId);){
            PersistenceEntry persistenceEntry = this.aJ.resolve(channelId.toString());
            persistenceEntry.deleteValue();
            Map<GUID, CoWorkChannel> map = this.aU.get(teamId);
            if (map != null) {
                map.remove(channelId);
                CoWorkChannel coWorkChannel = this.aT.remove(channelId);
                if (coWorkChannel != null) {
                    Object object = coWorkChannel.getDisplayName();
                    CoWorkTeam coWorkTeam = CoWorkManager.getInstance().getTeam(teamId);
                    if (coWorkTeam != null) {
                        object = coWorkTeam.getDisplayName() + " - " + (String)object;
                    }
                    a.aD.a(channelId.toString(), (String)object, null);
                }
                if (map.isEmpty()) {
                    this.aU.remove(teamId);
                }
            }
        }
    }
}

