/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.messages;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.server.webapi.attachments.AttachmentsListResponseData;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Response data for a message request")
public class MessageResponseData {
    @Schema(description="Unique identifier of the message")
    private GUID id;
    @Schema(description="Timestamp when the message was created", example="1612345678000")
    private long created;
    @Schema(description="Timestamp when the message was last modified", example="1612345678000")
    private long modified;
    @Schema(description="Unique identifier of the message author")
    private GUID userId;
    @Schema(description="Display name of the message author", example="John Doe")
    private String userDisplayName;
    @Schema(description="Message content, can be plain text or HTML depending on request parameters")
    private String text;
    @Schema(description="Map of reactions to the message, keyed by emoji with sets of users who reacted")
    private Map<String, Set<CoWorkMessage.ReactionEntry>> reactions = new LinkedHashMap<String, Set<CoWorkMessage.ReactionEntry>>();
    @Schema(description="List of attachments associated with the message")
    private AttachmentsListResponseData attachments = null;

    private MessageResponseData() {
    }

    public static MessageResponseData from(CoWorkMessage message, CoWorkChannel channel, boolean htmlMessage) {
        MessageResponseData messageResponseData = new MessageResponseData();
        messageResponseData.id = message.getId();
        messageResponseData.created = message.getCreated();
        messageResponseData.modified = message.getModified();
        messageResponseData.userId = message.getUserId();
        @Nullable LinkedHashMap<String, Set<CoWorkMessage.ReactionEntry>> linkedHashMap = message.getReactions();
        if (linkedHashMap != null) {
            messageResponseData.reactions.putAll(linkedHashMap);
        }
        UserAccount userAccount = messageResponseData.userId == null ? null : UserManager.getInstance().getUserAccount(messageResponseData.userId);
        messageResponseData.userDisplayName = userAccount == null ? CoWorkI18n.MSG_CLIENT.getMsg("cowork.username.bot", new Object[0]) : userAccount.getDisplayName();
        messageResponseData.text = htmlMessage ? message.getFormattedText() : message.getText();
        messageResponseData.attachments = AttachmentsListResponseData.from(message, channel);
        return messageResponseData;
    }
}

