/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.persistence;

import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.eventlog.a;
import com.inet.cowork.server.persistence.b;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class e
extends b {
    private final PersistenceEntry aJ;
    private final Map<GUID, CoWorkTeam> ba = new ConcurrentHashMap<GUID, CoWorkTeam>();

    public e() {
        this(Persistence.getInstance().resolve("cowork/team"));
    }

    e(@Nonnull PersistenceEntry persistenceEntry2) {
        super("MUT", 0);
        this.aJ = persistenceEntry2;
        persistenceEntry2.resolve(CoWorkManager.DIRECTMESSAGE_TEAM_ID.toString()).deleteValue();
        persistenceEntry2.getChildren().forEach(persistenceEntry -> {
            CoWorkTeam coWorkTeam = (CoWorkTeam)this.a((PersistenceEntry)persistenceEntry, new Type[]{CoWorkTeam.class});
            if (coWorkTeam != null) {
                this.ba.put(coWorkTeam.getId(), coWorkTeam);
            }
        });
    }

    public void t() {
        this.aJ.getChildren().forEach(persistenceEntry -> this.A(GUID.valueOf((String)persistenceEntry.getName())));
    }

    public void A(GUID gUID) {
        try (ServerLock serverLock = ThreadUtils.getReadLock((Object)gUID);){
            PersistenceEntry persistenceEntry = this.aJ.resolve(gUID.toString());
            CoWorkTeam coWorkTeam = (CoWorkTeam)this.a(persistenceEntry, new Type[]{CoWorkTeam.class});
            if (coWorkTeam != null) {
                this.ba.put(gUID, coWorkTeam);
            } else {
                this.ba.remove(gUID);
            }
        }
    }

    public CoWorkTeam getTeam(GUID teamId) {
        return this.ba.get(teamId);
    }

    public List<CoWorkTeam> u() {
        return new ArrayList<CoWorkTeam>(this.ba.values());
    }

    public void saveTeam(@Nonnull CoWorkTeam team) {
        GUID gUID = team.getId();
        this.A(gUID);
        try (ServerLock serverLock = ThreadUtils.getWriteLock((Object)gUID);){
            PersistenceEntry persistenceEntry = this.aJ.resolve(gUID.toString());
            CoWorkTeam coWorkTeam = this.ba.get(gUID);
            if (coWorkTeam == null || !coWorkTeam.equals(team)) {
                this.a(persistenceEntry, team);
                this.ba.put(gUID, team);
                if (coWorkTeam != null) {
                    List<String> list = this.c(coWorkTeam, team);
                    for (String string : list) {
                        a.az.a(gUID.toString(), team.getDisplayName(), string);
                    }
                } else {
                    a.ay.a(gUID.toString(), team.getDisplayName(), null);
                }
            }
        }
    }

    @Nonnull
    private List<String> c(@Nonnull CoWorkTeam coWorkTeam, @Nonnull CoWorkTeam coWorkTeam2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Objects.equals(coWorkTeam.getDisplayName(), coWorkTeam2.getDisplayName())) {
            arrayList.add("Name: " + coWorkTeam.getDisplayName() + " -> " + coWorkTeam2.getDisplayName());
        }
        this.a(arrayList, coWorkTeam.getAdminGroupIds(), coWorkTeam2.getAdminGroupIds(), "Admin Group", true);
        this.a(arrayList, coWorkTeam.getAdminUserIds(), coWorkTeam2.getAdminUserIds(), "Admin User", false);
        this.a(arrayList, coWorkTeam.getMemberGroupIds(), coWorkTeam2.getMemberGroupIds(), "Member Group", true);
        this.a(arrayList, coWorkTeam.getMemberUserIds(), coWorkTeam2.getMemberUserIds(), "Member User", false);
        return arrayList;
    }

    private void a(@Nonnull List<String> list, @Nullable HashSet<GUID> hashSet, @Nullable HashSet<GUID> hashSet2, String string, boolean bl) {
        HashSet<GUID> hashSet3 = new HashSet<GUID>();
        if (hashSet != null) {
            hashSet3.addAll(hashSet);
        }
        HashSet<GUID> hashSet4 = new HashSet<GUID>();
        if (hashSet2 != null) {
            hashSet4.addAll(hashSet2);
        }
        if (Objects.equals(hashSet3, hashSet4)) {
            return;
        }
        HashSet hashSet5 = new HashSet(hashSet3);
        hashSet3.removeIf(gUID -> hashSet4.contains(gUID));
        hashSet4.removeIf(gUID -> hashSet5.contains(gUID));
        hashSet3.forEach(gUID -> {
            if (bl) {
                UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
                if (userGroupInfo != null) {
                    list.add("Removed " + string + ": " + userGroupInfo.getDisplayName());
                }
            } else {
                UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
                if (userAccount != null) {
                    list.add("Removed " + string + ": " + userAccount.getDisplayName());
                }
            }
        });
        hashSet4.forEach(gUID -> {
            if (bl) {
                UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(gUID);
                if (userGroupInfo != null) {
                    list.add("Added " + string + ": " + userGroupInfo.getDisplayName());
                }
            } else {
                UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
                if (userAccount != null) {
                    list.add("Added " + string + ": " + userAccount.getDisplayName());
                }
            }
        });
    }

    public void deleteTeam(GUID teamId) {
        List<CoWorkChannel> list = CoWorkManager.getInstance().getChannels(teamId);
        if (!list.isEmpty()) {
            throw new ClientMessageException(CoWorkI18n.MSG_SERVER.getMsg("error.team.delete.notempty", new Object[0]));
        }
        try (ServerLock serverLock = ThreadUtils.getWriteLock((Object)teamId);){
            PersistenceEntry persistenceEntry = this.aJ.resolve(teamId.toString());
            persistenceEntry.deleteValue();
            CoWorkTeam coWorkTeam = this.ba.remove(teamId);
            if (coWorkTeam != null) {
                a.aA.a(teamId.toString(), coWorkTeam.getDisplayName(), null);
            }
        }
    }
}

