/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.model;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import java.util.HashMap;
import javax.annotation.Nonnull;

@JsonData
public class CoWorkAttachment {
    private GUID id;
    private String type = "file";
    private String name;
    private long size;
    private HashMap<String, String> properties = new HashMap();

    private CoWorkAttachment() {
    }

    public static CoWorkAttachment create(GUID id, String name, long size) {
        CoWorkAttachment coWorkAttachment = new CoWorkAttachment();
        if (id == null) {
            id = GUID.generateNew();
        }
        coWorkAttachment.id = id;
        coWorkAttachment.name = name;
        coWorkAttachment.size = size;
        return coWorkAttachment;
    }

    public GUID getId() {
        return this.id;
    }

    public void setId(GUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }
}

