/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.user;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.model.MemberStatus;
import com.inet.cowork.api.model.UserStatus;
import com.inet.cowork.server.webapi.user.UserStatusInformationRequest;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonData
@Schema(description="Response data containing a user's current online status information")
public class UserStatusInformationResponse
extends UserStatusInformationRequest {
    @Schema(description="Unique identifier of the user")
    private GUID id;
    @Schema(description="Display name of the user shown in the sidebar", example="John Doe")
    private String displayName;

    private UserStatusInformationResponse() {
    }

    private UserStatusInformationResponse(UserStatus userStatus) {
        super(userStatus);
    }

    public UserStatusInformationResponse(MemberStatus memberStatus) {
        super(memberStatus);
    }

    public static UserStatusInformationResponse from(String displayName, GUID userId, UserStatus currentUserStatus) {
        UserStatusInformationResponse userStatusInformationResponse = new UserStatusInformationResponse(currentUserStatus);
        userStatusInformationResponse.displayName = displayName;
        userStatusInformationResponse.id = userId;
        return userStatusInformationResponse;
    }

    public static UserStatusInformationResponse from(MemberStatus memberStatus) {
        UserStatusInformationResponse userStatusInformationResponse = new UserStatusInformationResponse(memberStatus);
        userStatusInformationResponse.displayName = memberStatus.getDisplayName();
        userStatusInformationResponse.id = memberStatus.getId();
        return userStatusInformationResponse;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public GUID getUserId() {
        return this.id;
    }
}

