/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.reactions;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.reactions.ReactionsRequestData;
import com.inet.cowork.server.webapi.reactions.ReactionsResponseData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.remote.gui.emoji.EmojiData;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Tag(name="Reactions", description="Message reaction operations")
public class a
extends RequestHandler.WithParentPathToken<ReactionsRequestData, ReactionsResponseData, GUID> {
    public a() {
        super(new String[]{"reactions"});
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels.messages.reactions";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Operation(summary="Get or toggle message reactions", description="Retrieves reactions on a message or toggles a reaction for the current user. When adding a reaction, the emoji can be specified by shortname or Unicode.", responses={@ApiResponse(responseCode="200", description="Reactions retrieved or toggled successfully", content={@Content(schema=@Schema(implementation=ReactionsResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid emoji or missing post data"), @ApiResponse(responseCode="403", description="Channel not available or access forbidden"), @ApiResponse(responseCode="404", description="Message or channel not found")})
    public ReactionsResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable ReactionsRequestData reactionsRequestData, @Nullable GUID gUID, boolean bl) throws IOException {
        if (gUID == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Message ID is missing.");
            return null;
        }
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        GUID gUID2 = CoWorkWebAPIUtils.getGUIDFromPathInfo(httpServletRequest, "channels");
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID2);
        if (coWorkChannel == null) {
            return null;
        }
        CoWorkMessage coWorkMessage = coWorkManager.getMessage(coWorkChannel.getId(), gUID);
        if (coWorkMessage == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Message is not available.");
            return null;
        }
        if (reactionsRequestData != null && !StringFunctions.isEmpty((String)reactionsRequestData.getEmoji())) {
            List list = EmojiData.searchEmojis((String)reactionsRequestData.getEmoji());
            if (list.isEmpty()) {
                Map.Entry entry;
                String string = (String)EmojiData.getTextEmojiMap().get(reactionsRequestData.getEmoji());
                if (StringFunctions.isEmpty((String)string) && (entry = (Map.Entry)EmojiData.getUnicodeSearchTree().findPath(reactionsRequestData.getEmoji())) != null) {
                    string = (String)entry.getKey();
                }
                this.a(list, string);
            } else if (!((EmojiData.EmojiMatch)list.get(0)).isMatchedByShortName()) {
                this.a(list, ((EmojiData.EmojiMatch)list.get(0)).getCode());
            }
            if (list.isEmpty() || ((EmojiData.EmojiMatch)list.get(0)).getSortPriority() != 0) throw new ClientMessageException(com.inet.cowork.server.webapi.a.bz.getMsg("response.emojiNotFound", new Object[]{reactionsRequestData.getEmoji()}));
            if (bl) return ReactionsResponseData.from(coWorkMessage);
            coWorkManager.toggleReaction(gUID2, gUID, UserManager.getInstance().getCurrentUserAccountID(), ((EmojiData.EmojiMatch)list.get(0)).getCleanEmojiShortName());
            return ReactionsResponseData.from(coWorkMessage);
        } else {
            if (!this.isMethodAllowedForData(httpServletRequest)) return ReactionsResponseData.from(coWorkMessage);
            throw new ClientMessageException(com.inet.cowork.server.webapi.a.bz.getMsg("response.noPostData", new Object[0]));
        }
    }

    private void a(List<EmojiData.EmojiMatch> list, String string) {
        String string2;
        if (!StringFunctions.isEmpty((String)string) && (string2 = (String)EmojiData.getShortNameMap().entrySet().stream().filter(entry -> string.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null)) != null) {
            list.add(0, new EmojiData.EmojiMatch(string, string2, 0, true));
        }
    }

    @Operation(summary="Get or toggle message reactions", description="Retrieves reactions on a message or toggles a reaction for the current user. When adding a reaction, the emoji can be specified by shortname or Unicode.", responses={@ApiResponse(responseCode="200", description="Reactions retrieved or toggled successfully", content={@Content(schema=@Schema(implementation=ReactionsResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid emoji or missing post data"), @ApiResponse(responseCode="403", description="Channel not available or access forbidden"), @ApiResponse(responseCode="404", description="Message or channel not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ReactionsRequestData)object, (GUID)object2, bl);
    }
}

