/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.channels;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.channels.ChannelCreateRequestData;
import com.inet.cowork.server.webapi.channels.ChannelResponseData;
import com.inet.cowork.server.webapi.channels.c;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Admin Channels", description="Administrative channel management operations")
public class a
extends c {
    public a() {
        super("channel");
        this.registerRequestHandler((RequestHandlerBase)new com.inet.cowork.server.webapi.messages.a());
    }

    @Override
    public String getHelpPageKey() {
        return "webapi.cowork.admin.teams.channels.id";
    }

    @Operation(summary="Manage specific administrative channel", description="Get, update, or delete a specific channel by its GUID. Requires team admin permission.", requestBody=@RequestBody(description="Channel update data", content={@Content(schema=@Schema(implementation=ChannelCreateRequestData.class))}), responses={@ApiResponse(responseCode="200", description="Channel details retrieved or updated successfully", content={@Content(schema=@Schema(implementation=ChannelResponseData.class))}), @ApiResponse(responseCode="204", description="Channel deleted successfully"), @ApiResponse(responseCode="400", description="Invalid channel update data or deletion request"), @ApiResponse(responseCode="403", description="Access denied - user is not a team admin"), @ApiResponse(responseCode="404", description="Channel not found")})
    public ChannelResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable ChannelCreateRequestData channelCreateRequestData, @Nullable GUID gUID, List<String> list, boolean bl) throws IOException {
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID);
        if (coWorkChannel == null) {
            return null;
        }
        if ("DELETE".equalsIgnoreCase(httpServletRequest.getMethod())) {
            if (list.size() > 0) {
                throw new ClientMessageException("Channel deletion requested, but this was probably the wrong handler. You also sent the following tokens along: " + String.join((CharSequence)"/", list));
            }
            if (!bl) {
                CoWorkManager.getInstance().deleteChannel(coWorkChannel.getTeamId(), coWorkChannel.getId());
            }
            httpServletResponse.setStatus(204);
            return null;
        }
        coWorkChannel = this.a(httpServletRequest, coWorkChannel, channelCreateRequestData, bl);
        return ChannelResponseData.from(coWorkChannel, true);
    }

    private CoWorkChannel a(HttpServletRequest httpServletRequest, CoWorkChannel coWorkChannel, ChannelCreateRequestData channelCreateRequestData, boolean bl) {
        if (channelCreateRequestData == null) {
            if (this.isMethodAllowedForData(httpServletRequest)) {
                throw new ClientMessageException("Channel update requested, but no data sent.");
            }
            return coWorkChannel;
        }
        CoWorkChannel coWorkChannel2 = null;
        coWorkChannel2 = channelCreateRequestData.isMembersInherited() ? CoWorkChannel.create(coWorkChannel.getId(), coWorkChannel.getTeamId(), channelCreateRequestData.getDisplayName(), channelCreateRequestData.getDescription()) : CoWorkChannel.create(coWorkChannel.getId(), coWorkChannel.getTeamId(), channelCreateRequestData.getDisplayName(), channelCreateRequestData.getDescription(), channelCreateRequestData.getMemberUserIDs(), channelCreateRequestData.getMemberGroupIDs());
        if (!bl) {
            CoWorkManager.getInstance().saveChannel(coWorkChannel2);
        }
        return coWorkChannel2;
    }

    @Operation(summary="Manage specific administrative channel", description="Get, update, or delete a specific channel by its GUID. Requires team admin permission.", requestBody=@RequestBody(description="Channel update data", content={@Content(schema=@Schema(implementation=ChannelCreateRequestData.class))}), responses={@ApiResponse(responseCode="200", description="Channel details retrieved or updated successfully", content={@Content(schema=@Schema(implementation=ChannelResponseData.class))}), @ApiResponse(responseCode="204", description="Channel deleted successfully"), @ApiResponse(responseCode="400", description="Invalid channel update data or deletion request"), @ApiResponse(responseCode="403", description="Access denied - user is not a team admin"), @ApiResponse(responseCode="404", description="Channel not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, List list, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ChannelCreateRequestData)object, (GUID)object2, list, bl);
    }
}

