/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.data;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.CoWorkPermissions;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import javax.annotation.Nonnull;

@JsonData
public class MemberDescription {
    private String displayName;
    private boolean active;
    private boolean externalUser;

    private MemberDescription() {
    }

    private MemberDescription(String displayName, boolean active, boolean externalUser) {
        this.displayName = displayName;
        this.active = active;
        this.externalUser = externalUser;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Nonnull
    public static MemberDescription ofGroup(@Nonnull UserGroupInfo group) {
        return new MemberDescription(UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)group), true, false);
    }

    @Nonnull
    public static MemberDescription ofUser(@Nonnull UserAccount user) {
        return new MemberDescription(user.getDisplayName(), SystemPermissionChecker.hasAnyPermission((GUID)user.getID(), (Permission[])new Permission[]{CoWorkPermissions.PERMISSION_COWORK}), UserAccountType.Temp.equals((Object)user.getAccountType()));
    }
}

