/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.attachments;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.attachments.AttachmentsListResponseData;
import com.inet.cowork.server.webapi.attachments.a;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Tag(name="Attachments", description="Operations for managing message attachments")
public class b
extends RequestHandler.WithParentPathToken<Void, AttachmentsListResponseData, GUID> {
    public b() {
        super(new String[]{"attachments"});
        this.setGenericRequestHandler((RequestHandler)new a());
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels.messages.attachments";
    }

    @Operation(summary="List message attachments", description="Retrieves a list of attachments for a specific message in a channel", responses={@ApiResponse(responseCode="200", description="List of attachments retrieved successfully", content={@Content(schema=@Schema(implementation=AttachmentsListResponseData.class))}), @ApiResponse(responseCode="404", description="Channel or message not found")})
    public AttachmentsListResponseData b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Nullable GUID gUID, boolean bl) throws IOException {
        if (gUID == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Message ID is missing.");
            return null;
        }
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        GUID gUID2 = CoWorkWebAPIUtils.getGUIDFromPathInfo(httpServletRequest, "channels");
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID2);
        if (coWorkChannel == null) {
            return null;
        }
        CoWorkMessage coWorkMessage = coWorkManager.getMessage(coWorkChannel.getId(), gUID);
        if (coWorkMessage == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Message is not available.");
            return null;
        }
        return AttachmentsListResponseData.from(coWorkMessage, coWorkChannel);
    }

    @Operation(summary="List message attachments", description="Retrieves a list of attachments for a specific message in a channel", responses={@ApiResponse(responseCode="200", description="List of attachments retrieved successfully", content={@Content(schema=@Schema(implementation=AttachmentsListResponseData.class))}), @ApiResponse(responseCode="404", description="Channel or message not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (Void)object, (GUID)object2, bl);
    }
}

