/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.model;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.model.OnlineStatus;
import com.inet.id.GUID;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class UserStatus {
    @Nonnull
    private GUID id;
    private OnlineStatus status;
    private String customStatus;
    private boolean idle;
    private Set<String> flags = new HashSet<String>();

    private UserStatus() {
    }

    public UserStatus(@Nonnull GUID id, OnlineStatus status, String customStatus, Set<String> flags) {
        this.id = id;
        this.status = status;
        this.customStatus = customStatus;
        if (flags != null) {
            this.flags = flags;
        }
    }

    @Nonnull
    public GUID getId() {
        return this.id;
    }

    public OnlineStatus getStatus() {
        if (this.idle && this.status == OnlineStatus.online) {
            return OnlineStatus.away;
        }
        return this.status;
    }

    public String getCustomStatus() {
        return this.customStatus;
    }

    public void setStatus(OnlineStatus status) {
        this.status = status;
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    public boolean isIdle() {
        return this.idle;
    }

    @Nonnull
    public Set<String> getFlags() {
        return this.flags;
    }
}

