/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.model;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.CoWorkPermissions;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class CoWorkTeam {
    private GUID id;
    private String displayName;
    private Set<GUID> memberUserIds;
    private Set<GUID> memberGroupIds;
    private Set<GUID> adminUserIds;
    private Set<GUID> adminGroupIds;
    private long lastModified;
    private transient Supplier<String> displayNameProvider;
    private transient boolean predefined;

    private CoWorkTeam() {
    }

    public static CoWorkTeam create(GUID id, String displayName, Set<GUID> memberUserIds, Set<GUID> membersGroupIds, Set<GUID> adminsUserIds, Set<GUID> adminsGroupIds) {
        CoWorkTeam coWorkTeam = new CoWorkTeam();
        if (id == null) {
            id = GUID.generateNew();
        }
        coWorkTeam.id = id;
        coWorkTeam.displayName = displayName;
        coWorkTeam.memberUserIds = memberUserIds;
        coWorkTeam.memberGroupIds = membersGroupIds;
        coWorkTeam.adminUserIds = adminsUserIds;
        coWorkTeam.adminGroupIds = adminsGroupIds;
        return coWorkTeam;
    }

    public static CoWorkTeam createPredefinedTeam(GUID id, Supplier<String> displayNameProvider) {
        CoWorkTeam coWorkTeam = new CoWorkTeam();
        if (id == null) {
            id = GUID.generateNew();
        }
        coWorkTeam.id = id;
        coWorkTeam.displayNameProvider = displayNameProvider;
        coWorkTeam.predefined = true;
        return coWorkTeam;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public boolean isAvailable() {
        return this.isAvailable(UserManager.getInstance().getCurrentUserAccountID());
    }

    public boolean isAvailable(GUID userId) {
        if (userId == null) {
            return false;
        }
        if (!SystemPermissionChecker.hasAnyPermission((GUID)userId, (Permission[])new Permission[]{CoWorkPermissions.PERMISSION_COWORK})) {
            return false;
        }
        if (this.predefined) {
            return true;
        }
        if (this.memberUserIds != null && this.memberUserIds.contains(userId)) {
            return true;
        }
        return this.memberGroupIds != null && this.isGroupMember(this.memberGroupIds, userId);
    }

    private boolean isGroupMember(Set<GUID> memberGroupIds, GUID currentUserAccountID) {
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        Set set = userGroupManager.getGroupsForUser(currentUserAccountID);
        set.removeIf(g2 -> !memberGroupIds.contains(g2.getID()));
        return !set.isEmpty();
    }

    public boolean isAdmin() {
        return this.isAdmin(UserManager.getInstance().getCurrentUserAccountID());
    }

    public boolean isAdmin(GUID userId) {
        if (userId == null) {
            return false;
        }
        if (SystemPermissionChecker.checkAccess((Permission)CoWorkPermissions.PERMISSION_COWORK_ADMIN)) {
            return true;
        }
        if (this.adminUserIds != null && this.adminUserIds.contains(userId)) {
            return true;
        }
        return this.adminGroupIds != null && this.isGroupMember(this.adminGroupIds, userId);
    }

    @Nonnull
    public Set<GUID> getAllMemberIds() {
        Set<Object> set = new HashSet<GUID>();
        if (this.memberUserIds != null) {
            set = this.memberUserIds.stream().filter(id -> SystemPermissionChecker.hasAnyPermission((GUID)id, (Permission[])new Permission[]{CoWorkPermissions.PERMISSION_COWORK})).collect(Collectors.toSet());
        }
        if (this.memberGroupIds != null) {
            for (GUID gUID : this.memberGroupIds) {
                set.addAll(CoWorkTeam.getMembersOfGroup(gUID));
            }
        }
        return set;
    }

    static Set<GUID> getMembersOfGroup(GUID groupId) {
        UserGroupInfo userGroupInfo = UserGroupManager.getInstance().getGroup(groupId);
        if (userGroupInfo != null) {
            Optional<GroupTypeDef> optional;
            UserManager userManager = UserManager.getInstance();
            if (userGroupInfo.getID().equals((Object)UsersAndGroups.GROUPID_ALLUSERS)) {
                HashSet<GUID> hashSet = new HashSet<GUID>();
                hashSet.addAll(CoWorkManager.getInstance().getConnectedUsers().keySet());
                Iterator iterator = userManager.getIteratorOverUserAccountIDs();
                while (hashSet.size() < 1000 && iterator.hasNext()) {
                    GUID gUID = (GUID)iterator.next();
                    UserAccount userAccount = userManager.getUserAccount(gUID);
                    if (userAccount == null || !userAccount.isActive() || !SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{CoWorkPermissions.PERMISSION_COWORK})) continue;
                    hashSet.add(gUID);
                }
                return hashSet;
            }
            HashSet<GUID> hashSet = new HashSet<GUID>(userGroupInfo.getMemberIDs());
            if (hashSet.isEmpty() && userGroupInfo.getParentID() != null && (optional = ServerPluginManager.getInstance().get(GroupTypeDef.class).stream().filter(gt -> gt.getGroupType().equals((Object)userGroupInfo.getType())).findAny()).isPresent() && optional.get().inheritsMembershipsFromParent()) {
                return CoWorkTeam.getMembersOfGroup(userGroupInfo.getParentID());
            }
            hashSet.removeIf(userId -> {
                UserAccount userAccount = userManager.getUserAccount(userId);
                return userAccount == null || !userAccount.isActive() || !SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{CoWorkPermissions.PERMISSION_COWORK});
            });
            return hashSet;
        }
        return Collections.emptySet();
    }

    public GUID getId() {
        return this.id;
    }

    public void setId(GUID id) {
        this.id = id;
    }

    public String getDisplayName() {
        if (this.displayNameProvider != null) {
            return this.displayNameProvider.get();
        }
        return this.displayName;
    }

    @Nonnull
    public HashSet<GUID> getMemberUserIds() {
        if (this.memberUserIds == null || this.memberUserIds.isEmpty()) {
            return new HashSet<GUID>();
        }
        return new HashSet<GUID>(this.memberUserIds);
    }

    public void setMemberUserIds(HashSet<GUID> memberUserIds) {
        this.memberUserIds = memberUserIds;
    }

    @Nonnull
    public HashSet<GUID> getMemberGroupIds() {
        if (this.memberGroupIds == null || this.memberGroupIds.isEmpty()) {
            return new HashSet<GUID>();
        }
        return new HashSet<GUID>(this.memberGroupIds);
    }

    public void setMemberGroupIds(HashSet<GUID> memberGroupIds) {
        this.memberGroupIds = memberGroupIds;
    }

    @Nonnull
    public HashSet<GUID> getAdminUserIds() {
        if (this.adminUserIds == null || this.adminUserIds.isEmpty()) {
            return new HashSet<GUID>();
        }
        return new HashSet<GUID>(this.adminUserIds);
    }

    public void setAdminUserIds(HashSet<GUID> adminUserIds) {
        this.adminUserIds = adminUserIds;
    }

    @Nonnull
    public HashSet<GUID> getAdminGroupIds() {
        if (this.adminGroupIds == null || this.adminGroupIds.isEmpty()) {
            return new HashSet<GUID>();
        }
        return new HashSet<GUID>(this.adminGroupIds);
    }

    public void setAdminGroupIds(HashSet<GUID> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.adminGroupIds == null || this.adminGroupIds.isEmpty() ? 0 : this.adminGroupIds.hashCode());
        n3 = 31 * n3 + (this.adminUserIds == null || this.adminUserIds.isEmpty() ? 0 : this.adminUserIds.hashCode());
        n3 = 31 * n3 + (this.displayName == null ? 0 : this.displayName.hashCode());
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        n3 = 31 * n3 + (int)(this.lastModified ^ this.lastModified >>> 32);
        n3 = 31 * n3 + (this.memberGroupIds == null || this.memberGroupIds.isEmpty() ? 0 : this.memberGroupIds.hashCode());
        n3 = 31 * n3 + (this.memberUserIds == null || this.memberUserIds.isEmpty() ? 0 : this.memberUserIds.hashCode());
        return n3;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoWorkTeam coWorkTeam = (CoWorkTeam)obj;
        if (this.adminGroupIds == null || this.adminGroupIds.isEmpty() ? coWorkTeam.adminGroupIds != null && !coWorkTeam.adminGroupIds.isEmpty() : !this.adminGroupIds.equals(coWorkTeam.adminGroupIds)) {
            return false;
        }
        if (this.adminUserIds == null || this.adminUserIds.isEmpty() ? coWorkTeam.adminUserIds != null && !coWorkTeam.adminUserIds.isEmpty() : !this.adminUserIds.equals(coWorkTeam.adminUserIds)) {
            return false;
        }
        if (this.displayName == null ? coWorkTeam.displayName != null : !this.displayName.equals(coWorkTeam.displayName)) {
            return false;
        }
        if (this.id == null ? coWorkTeam.id != null : !this.id.equals((Object)coWorkTeam.id)) {
            return false;
        }
        if (this.lastModified != coWorkTeam.lastModified) {
            return false;
        }
        if (this.memberGroupIds == null || this.memberGroupIds.isEmpty() ? coWorkTeam.memberGroupIds != null && !coWorkTeam.memberGroupIds.isEmpty() : !this.memberGroupIds.equals(coWorkTeam.memberGroupIds)) {
            return false;
        }
        return !(this.memberUserIds == null || this.memberUserIds.isEmpty() ? coWorkTeam.memberUserIds != null && !coWorkTeam.memberUserIds.isEmpty() : !this.memberUserIds.equals(coWorkTeam.memberUserIds));
    }
}

