/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.channels;

import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.channels.ChannelCreateRequestData;
import com.inet.cowork.server.webapi.channels.ChannelResponseData;
import com.inet.cowork.server.webapi.directmessages.b;
import com.inet.cowork.server.webapi.members.a;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Tag(name="Channels", description="Channel management operations within teams")
public class c
extends RequestHandlerWithGUIDPathToken<ChannelCreateRequestData, ChannelResponseData> {
    public c() {
        super(new String[]{"channel"});
        this.registerRequestHandler((RequestHandlerBase)new com.inet.cowork.server.webapi.messages.c());
        this.registerRequestHandler((RequestHandlerBase)new a());
        this.registerRequestHandler((RequestHandlerBase)new b(false));
    }

    public c(String ... stringArray) {
        super(stringArray);
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels.id";
    }

    @Operation(summary="Get channel details", description="Retrieves detailed information about a specific channel within a team", responses={@ApiResponse(responseCode="200", description="Channel details retrieved successfully", content={@Content(schema=@Schema(implementation=ChannelResponseData.class))}), @ApiResponse(responseCode="403", description="Channel update/deletion attempted without admin context"), @ApiResponse(responseCode="404", description="Channel not found or not available")})
    public ChannelResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable ChannelCreateRequestData channelCreateRequestData, @Nullable GUID gUID, boolean bl) throws IOException {
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID);
        if (coWorkChannel == null) {
            return null;
        }
        if ("DELETE".equalsIgnoreCase(httpServletRequest.getMethod())) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"User did not request admin privileges.");
            return null;
        }
        if (this.isMethodAllowedForData(httpServletRequest)) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"Channel creation attempted, but admin context not requested.");
            return null;
        }
        return ChannelResponseData.from(coWorkChannel);
    }

    @Operation(summary="Get channel details", description="Retrieves detailed information about a specific channel within a team", responses={@ApiResponse(responseCode="200", description="Channel details retrieved successfully", content={@Content(schema=@Schema(implementation=ChannelResponseData.class))}), @ApiResponse(responseCode="403", description="Channel update/deletion attempted without admin context"), @ApiResponse(responseCode="404", description="Channel not found or not available")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ChannelCreateRequestData)object, (GUID)object2, bl);
    }
}

