/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.user;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.model.MemberStatus;
import com.inet.cowork.api.model.OnlineStatus;
import com.inet.cowork.api.model.UserStatus;
import com.inet.http.ClientMessageException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Request data for updating a user's online status")
public class UserStatusInformationRequest {
    @Schema(description="Custom status message displayed in the user sidebar", example="In a meeting")
    private String customStatus = null;
    @Schema(description="User's online status ('online', 'away', 'dnd', 'invisible')", example="online")
    private String onlineStatus = null;
    @Schema(description="Whether the user is in idle state")
    private Boolean isIdle = null;
    @Schema(description="Additional flags containing details about the user's status")
    private Set<String> flags = null;

    protected UserStatusInformationRequest() {
    }

    protected UserStatusInformationRequest(UserStatus userStatus) {
        this.customStatus = userStatus.getCustomStatus();
        this.onlineStatus = userStatus.getStatus().toString();
        this.isIdle = userStatus.isIdle();
        this.flags = userStatus.getFlags();
    }

    protected UserStatusInformationRequest(MemberStatus memberStatus) {
        this.customStatus = memberStatus.getCustomStatus();
        this.onlineStatus = memberStatus.getStatus().toString();
        this.isIdle = memberStatus.isIdle();
        this.flags = memberStatus.getFlags();
    }

    public String getCustomStatus() {
        return this.customStatus;
    }

    public OnlineStatus getOnlineStatus() {
        try {
            return OnlineStatus.valueOf(this.onlineStatus);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClientMessageException("Status must be one of: " + String.join((CharSequence)", ", Arrays.asList(OnlineStatus.values()).stream().map(v2 -> v2.name()).collect(Collectors.toList())));
        }
    }

    @Nullable
    public Boolean isIdle() {
        return this.isIdle;
    }

    public Set<String> getFlags() {
        return this.flags;
    }
}

