/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.teams;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.webapi.channels.d;
import com.inet.cowork.server.webapi.teams.TeamCreateRequestData;
import com.inet.cowork.server.webapi.teams.TeamGUIDResponseData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

@Tag(name="Teams", description="Team management operations")
public class c
extends RequestHandlerWithGUIDPathToken<TeamCreateRequestData, TeamGUIDResponseData> {
    public c() {
        super(new String[]{"team"});
        this.registerRequestHandler((RequestHandlerBase)new d());
    }

    public c(String ... stringArray) {
        super(stringArray);
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.id";
    }

    @Operation(summary="Get team details", description="Retrieves detailed information about a specific team including its channels", responses={@ApiResponse(responseCode="200", description="Team details retrieved successfully", content={@Content(schema=@Schema(implementation=TeamGUIDResponseData.class))}), @ApiResponse(responseCode="403", description="Team update or deletion attempted without admin context"), @ApiResponse(responseCode="404", description="Team not found or not available")})
    public TeamGUIDResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable TeamCreateRequestData teamCreateRequestData, @Nullable GUID gUID, List<String> list, boolean bl) throws IOException {
        boolean bl2 = "DELETE".equalsIgnoreCase(httpServletRequest.getMethod());
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        CoWorkTeam coWorkTeam = coWorkManager.getTeam(gUID);
        if (coWorkTeam == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)"Team is not available.");
            return null;
        }
        if (this.isMethodAllowedForData(httpServletRequest)) {
            throw new ClientMessageException("Team update attempted, but admin context not requested");
        }
        if (bl2) {
            ResponseWriter.forbidden((HttpServletResponse)httpServletResponse, (String)"User did not request admin privileges.");
            return null;
        }
        return TeamGUIDResponseData.from(coWorkTeam, false);
    }

    @Operation(summary="Get team details", description="Retrieves detailed information about a specific team including its channels", responses={@ApiResponse(responseCode="200", description="Team details retrieved successfully", content={@Content(schema=@Schema(implementation=TeamGUIDResponseData.class))}), @ApiResponse(responseCode="403", description="Team update or deletion attempted without admin context"), @ApiResponse(responseCode="404", description="Team not found or not available")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, List list, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (TeamCreateRequestData)object, (GUID)object2, list, bl);
    }
}

