/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.messages;

import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.attachments.CoWorkAttachmentUtils;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.data.CoWorkAttachmentDescription;
import com.inet.cowork.server.webapi.messages.CreateMessageRequestData;
import com.inet.cowork.server.webapi.messages.MessagesListResponseData;
import com.inet.cowork.server.webapi.messages.b;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Tag(name="Messages", description="Message operations within channels")
public class c
extends RequestHandler.WithParentPathToken<CreateMessageRequestData, MessagesListResponseData, GUID> {
    public c() {
        super(new String[]{"messages"});
        this.setGenericRequestHandler((RequestHandler)new b());
    }

    public c(String ... stringArray) {
        super(stringArray);
    }

    public String getHelpPageKey() {
        return "webapi.cowork.teams.channels.messages";
    }

    @Operation(summary="List or create messages", description="Retrieves messages from a channel or creates a new message. When retrieving messages, the response is windowed using a target message GUID as fixed point.", responses={@ApiResponse(responseCode="200", description="Messages retrieved or new message created successfully", content={@Content(schema=@Schema(implementation=MessagesListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid message data or channel not available"), @ApiResponse(responseCode="404", description="Channel not found")})
    public MessagesListResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable CreateMessageRequestData createMessageRequestData, @Nullable GUID gUID, boolean bl) throws IOException {
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID);
        if (coWorkChannel == null) {
            return null;
        }
        if (!coWorkChannel.isAvailable()) {
            throw new ClientMessageException("Messages are not available.");
        }
        CoWorkMessage coWorkMessage = this.a(httpServletRequest, coWorkChannel, createMessageRequestData, UserManager.getInstance().getCurrentUserAccountID(), bl);
        if (coWorkMessage != null) {
            ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)coWorkMessage.getId());
            return MessagesListResponseData.from(Arrays.asList(coWorkMessage));
        }
        GUID gUID2 = null;
        String string = httpServletRequest.getParameter("targetMessage");
        if (string != null) {
            try {
                gUID2 = GUID.valueOf((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        List<CoWorkMessage> list = coWorkManager.getMessagesInChannel(coWorkChannel.getId(), gUID2);
        MessagesListResponseData messagesListResponseData = MessagesListResponseData.from(list);
        ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)messagesListResponseData);
        return messagesListResponseData;
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }

    protected CoWorkMessage a(HttpServletRequest httpServletRequest, CoWorkChannel coWorkChannel, CreateMessageRequestData createMessageRequestData, GUID gUID, boolean bl) {
        if (createMessageRequestData == null) {
            if (this.isMethodAllowedForData(httpServletRequest)) {
                throw new ClientMessageException("A Message was expected but not given.");
            }
            return null;
        }
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        String string = createMessageRequestData.getText();
        List<CoWorkAttachmentDescription> list = createMessageRequestData.getAttachments();
        if (StringFunctions.isEmpty((String)string) && list == null) {
            throw new ClientMessageException("Message did not contain any text or attachments.");
        }
        List<GUID> list2 = coWorkChannel.getMemberUserIds();
        if (CoWorkManager.DIRECTMESSAGE_TEAM_ID.equals((Object)coWorkChannel.getTeamId()) && list2.size() == 1) {
            throw new ClientMessageException("Direct messages channel is already closed. You have to open a new direct messages channel");
        }
        if (bl) {
            list2 = new CoWorkMessage(gUID, string);
            if (list != null && !list.isEmpty()) {
                ((CoWorkMessage)((Object)list2)).setAttachmentsIds(list.stream().map(coWorkAttachmentDescription -> GUID.generateNew()).collect(Collectors.toList()));
            }
            return list2;
        }
        list2 = CoWorkAttachmentUtils.saveAttachmentsForRequest(coWorkChannel.getId(), list, httpServletRequest);
        return coWorkManager.addMessage(null, coWorkChannel.getId(), gUID, null, string, list2);
    }

    @Operation(summary="List or create messages", description="Retrieves messages from a channel or creates a new message. When retrieving messages, the response is windowed using a target message GUID as fixed point.", responses={@ApiResponse(responseCode="200", description="Messages retrieved or new message created successfully", content={@Content(schema=@Schema(implementation=MessagesListResponseData.class))}), @ApiResponse(responseCode="400", description="Invalid message data or channel not available"), @ApiResponse(responseCode="404", description="Channel not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (CreateMessageRequestData)object, (GUID)object2, bl);
    }
}

