/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.messages;

import com.inet.authentication.AccessForbiddenException;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkMessage;
import com.inet.cowork.api.webapi.CoWorkWebAPIUtils;
import com.inet.cowork.server.webapi.messages.CreateMessageRequestData;
import com.inet.cowork.server.webapi.messages.MessagesListResponseData;
import com.inet.cowork.server.webapi.messages.c;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

@Tag(name="Bot Messages", description="Bot message operations in channels")
public class a
extends c {
    public a() {
        super("botmessage");
    }

    @Override
    public String getHelpPageKey() {
        return "webapi.cowork.admin.teams.channels.botmessage";
    }

    @Override
    @Operation(summary="Send bot message", description="Sends a message as a bot into a channel. This endpoint allows admin users to post messages without requiring read access to the channel.", responses={@ApiResponse(responseCode="200", description="Bot message sent successfully", content={@Content(schema=@Schema(implementation=MessagesListResponseData.class))}), @ApiResponse(responseCode="403", description="Access forbidden - only bot message sending is allowed"), @ApiResponse(responseCode="404", description="Channel not found")})
    public MessagesListResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable CreateMessageRequestData createMessageRequestData, @Nullable GUID gUID, boolean bl) throws IOException {
        CoWorkChannel coWorkChannel = CoWorkWebAPIUtils.checkAndGetChannelIfIsValid(httpServletRequest, httpServletResponse, gUID);
        if (coWorkChannel == null) {
            return null;
        }
        CoWorkMessage coWorkMessage = this.a(httpServletRequest, coWorkChannel, createMessageRequestData, null, bl);
        if (coWorkMessage != null) {
            ResponseWriter.json((HttpServletResponse)httpServletResponse, (Object)coWorkMessage.getId());
            return MessagesListResponseData.from(Arrays.asList(coWorkMessage));
        }
        throw new AccessForbiddenException("Only sending bot messages is allowed here.");
    }

    @Override
    @Operation(summary="Send bot message", description="Sends a message as a bot into a channel. This endpoint allows admin users to post messages without requiring read access to the channel.", responses={@ApiResponse(responseCode="200", description="Bot message sent successfully", content={@Content(schema=@Schema(implementation=MessagesListResponseData.class))}), @ApiResponse(responseCode="403", description="Access forbidden - only bot message sending is allowed"), @ApiResponse(responseCode="404", description="Channel not found")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (CreateMessageRequestData)object, (GUID)object2, bl);
    }
}

