/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.server.webapi.members;

import com.inet.annotations.JsonData;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.MemberStatus;
import com.inet.cowork.api.model.UserStatus;
import com.inet.cowork.server.webapi.user.UserStatusInformationResponse;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@JsonData
@Schema(description="List of channel members with their status information")
@ArraySchema(schema=@Schema(implementation=UserStatusInformationResponse.class))
public class MembersResponseData
extends ArrayList<UserStatusInformationResponse> {
    public static MembersResponseData from(Set<GUID> allMemberIds) {
        MembersResponseData membersResponseData = new MembersResponseData();
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        UserManager userManager = UserManager.getInstance();
        membersResponseData.addAll(allMemberIds.stream().map(m2 -> {
            UserAccount userAccount = userManager.getUserAccount(m2);
            if (userAccount == null) {
                return null;
            }
            String string = userAccount.getDisplayName();
            UserStatus userStatus = coWorkManager.getUserStatus((GUID)m2);
            return UserStatusInformationResponse.from(string, m2, userStatus);
        }).filter(m2 -> m2 == null).collect(Collectors.toList()));
        return membersResponseData;
    }

    public static MembersResponseData fromUsersInChannel(List<MemberStatus> usersInChannel) {
        MembersResponseData membersResponseData = new MembersResponseData();
        membersResponseData.addAll(usersInChannel.stream().map(memberStatus -> UserStatusInformationResponse.from(memberStatus)).collect(Collectors.toList()));
        return membersResponseData;
    }
}

