/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.api.webapi;

import com.inet.annotations.InternalApi;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.model.CoWorkTeam;
import com.inet.cowork.server.webapi.admin.a;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.PathTokenizer;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class CoWorkWebAPIUtils {
    @Nonnull
    public static RequestHandler<?, ?> getChannelsHandler() {
        WebAPIExtension webAPIExtension = (WebAPIExtension)ServerPluginManager.getInstance().getSingleInstanceByName(WebAPIExtension.class, "cowork", false);
        RequestHandlerBase requestHandlerBase = webAPIExtension.getHandler("teams");
        Objects.requireNonNull(requestHandlerBase, "The CoWork API extension did not have a teams handler!");
        RequestHandler requestHandler = requestHandlerBase.getGenericRequestHandler();
        Objects.requireNonNull(requestHandler, "The CoWork API teams request handler did not have a generic request handler!");
        RequestHandlerBase requestHandlerBase2 = requestHandler.getHandler("channels");
        Objects.requireNonNull(requestHandlerBase2, "The CoWork API generic teams handler did not have a channels handler!");
        RequestHandler requestHandler2 = requestHandlerBase2.getGenericRequestHandler();
        Objects.requireNonNull(requestHandlerBase2, "The CoWork API channels handler did not have a generic request handler!");
        return requestHandler2;
    }

    @Nonnull
    public static RequestHandlerBase<?, ?> getUserHandler() {
        WebAPIExtension webAPIExtension = (WebAPIExtension)ServerPluginManager.getInstance().getSingleInstanceByName(WebAPIExtension.class, "cowork", false);
        RequestHandlerBase requestHandlerBase = webAPIExtension.getHandler("user");
        Objects.requireNonNull(requestHandlerBase, "The CoWork API extension did not have a user handler!");
        return requestHandlerBase;
    }

    @Nullable
    public static GUID getChannelGUIDFromPathInfo(HttpServletRequest request) {
        return CoWorkWebAPIUtils.getGUIDFromPathInfo(request, "channels");
    }

    @Nullable
    public static GUID getGUIDFromPathInfo(HttpServletRequest request, String prefix) {
        List list = PathTokenizer.convertPathToTokens((String)request.getPathInfo());
        int n2 = list.indexOf("cowork");
        if (n2 < 0 || list.size() <= n2 + 1) {
            return null;
        }
        List list2 = list.subList(n2 + 1, list.size());
        int n3 = list2.indexOf(prefix);
        if (n3 < 0 || list2.size() <= n3 + 1) {
            return null;
        }
        try {
            return GUID.valueOf((String)((String)list2.get(n3 + 1)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nullable
    public static CoWorkChannel checkAndGetChannelIfIsValid(HttpServletRequest request, HttpServletResponse response, GUID channelId) {
        boolean bl = a.a(request);
        CoWorkManager coWorkManager = CoWorkManager.getInstance();
        GUID gUID = CoWorkWebAPIUtils.getGUIDFromPathInfo(request, "teams");
        if (gUID == null) {
            ResponseWriter.notFound((HttpServletResponse)response, (String)"A valid team ID was not given.");
            return null;
        }
        CoWorkTeam coWorkTeam = coWorkManager.getTeam(gUID);
        if (coWorkTeam == null) {
            ResponseWriter.notFound((HttpServletResponse)response, (String)"Team not found or user has no access to the given team.");
            return null;
        }
        if (channelId == null) {
            ResponseWriter.notFound((HttpServletResponse)response, (String)"A valid channel ID was not given.");
            return null;
        }
        CoWorkChannel coWorkChannel = coWorkManager.getChannel(channelId);
        if (coWorkChannel == null) {
            ResponseWriter.notFound((HttpServletResponse)response, (String)"Channel could not be not found.");
            return null;
        }
        GUID gUID2 = coWorkChannel.getTeamId();
        if (!gUID2.equals((Object)coWorkTeam.getId())) {
            throw new ClientMessageException("Requested channel is not within the given team.");
        }
        if (bl && coWorkTeam.isPredefined()) {
            ResponseWriter.forbidden((HttpServletResponse)response, (String)"Channel is not available.");
            return null;
        }
        if (bl && coWorkTeam.isAdmin()) {
            return coWorkChannel;
        }
        if (!bl && !coWorkChannel.isAvailable()) {
            ResponseWriter.forbidden((HttpServletResponse)response, (String)"Channel is not available.");
            return null;
        }
        if (bl && !coWorkTeam.isAdmin()) {
            ResponseWriter.forbidden((HttpServletResponse)response, (String)"Channel is not available.");
            return null;
        }
        return coWorkChannel;
    }
}

