/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.meetingrooms.server.handler;

import com.inet.config.ConfigKeyParser;
import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.ui.CoWorkHandler;
import com.inet.cowork.meetingrooms.CoWorkMeetingRoomsServerPlugin;
import com.inet.cowork.meetingrooms.server.data.CreateNewMeetingRoomRequest;
import com.inet.cowork.meetingrooms.server.data.CreateNewMeetingRoomResponse;
import com.inet.http.ClientMessageException;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import javax.annotation.SuppressFBWarnings;

public class f
extends CoWorkHandler<CreateNewMeetingRoomRequest, CreateNewMeetingRoomResponse> {
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Base64 image data will be stored in the model only.")
    public CreateNewMeetingRoomResponse a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, CreateNewMeetingRoomRequest createNewMeetingRoomRequest) throws IOException {
        if (!ConfigKeyParser.hasValidLicenseFor((String)"cowork")) {
            WebSocketEventHandler.getInstance().sendEvent(createNewMeetingRoomRequest.getClientId(), () -> new WebSocketEventData("cowork.error", (Object)CoWorkI18n.MSG_SERVER.getMsg("cowork.licenserequired", new Object[0])));
            return null;
        }
        if (!SystemPermissionChecker.checkAccess((Permission)CoWorkMeetingRoomsServerPlugin.PERMISSION_COWORK_MEETINGROOMS)) {
            throw new AccessDeniedException(CoWorkMeetingRoomsServerPlugin.PERMISSION_COWORK_MEETINGROOMS);
        }
        HashSet<GUID> hashSet = new HashSet<GUID>();
        hashSet.add(UserManager.getInstance().getCurrentUserAccountID());
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new ClientMessageException("No user is currently logged in.");
        }
        CoWorkChannel coWorkChannel = CoWorkChannel.create(null, (GUID)CoWorkMeetingRoomsServerPlugin.MEETINGROOMS_TEAM_ID, (String)createNewMeetingRoomRequest.getName(), (String)createNewMeetingRoomRequest.getDescription(), hashSet, null);
        String string = createNewMeetingRoomRequest.getIconData();
        if (string != null && string.startsWith("data:")) {
            try (InputStream inputStream = new URL(string).openStream();){
                coWorkChannel.setIcon(IOFunctions.readBytes((InputStream)inputStream));
            }
        }
        CoWorkManager.getInstance().saveChannel(coWorkChannel);
        return new CreateNewMeetingRoomResponse(coWorkChannel.getId());
    }

    public String getMethodName() {
        return "cowork.meetingrooms.createnew";
    }

    public short getMethodType() {
        return 1;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Base64 image data will be stored in the model only.")
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (CreateNewMeetingRoomRequest)object);
    }
}

