/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cowork.meetingrooms.server.handler;

import com.inet.config.ConfigKeyParser;
import com.inet.cowork.api.CoWorkI18n;
import com.inet.cowork.api.CoWorkManager;
import com.inet.cowork.api.model.CoWorkChannel;
import com.inet.cowork.api.ui.CoWorkHandler;
import com.inet.cowork.meetingrooms.CoWorkMeetingRoomsServerPlugin;
import com.inet.cowork.meetingrooms.server.data.ChangeMeetingRoomDetailsRequest;
import com.inet.http.ClientMessageException;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;

public class b
extends CoWorkHandler<ChangeMeetingRoomDetailsRequest, Void> {
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Base64 image data will be stored in the model only.")
    public Void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ChangeMeetingRoomDetailsRequest changeMeetingRoomDetailsRequest) throws IOException {
        if (!ConfigKeyParser.hasValidLicenseFor((String)"cowork")) {
            WebSocketEventHandler.getInstance().sendEvent(changeMeetingRoomDetailsRequest.getClientId(), () -> new WebSocketEventData("cowork.error", (Object)CoWorkI18n.MSG_SERVER.getMsg("cowork.licenserequired", new Object[0])));
            return null;
        }
        if (!SystemPermissionChecker.checkAccess((Permission)CoWorkMeetingRoomsServerPlugin.PERMISSION_COWORK_MEETINGROOMS)) {
            throw new AccessDeniedException(CoWorkMeetingRoomsServerPlugin.PERMISSION_COWORK_MEETINGROOMS);
        }
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new ClientMessageException("No user is currently logged in.");
        }
        GUID gUID = changeMeetingRoomDetailsRequest.getChannelId();
        CoWorkChannel coWorkChannel = CoWorkManager.getInstance().getChannel(gUID);
        if (coWorkChannel == null || !coWorkChannel.getTeamId().equals((Object)CoWorkMeetingRoomsServerPlugin.MEETINGROOMS_TEAM_ID)) {
            throw new ClientMessageException("Meeting Room not available.");
        }
        CoWorkChannel coWorkChannel2 = CoWorkChannel.create((GUID)coWorkChannel.getId(), (GUID)coWorkChannel.getTeamId(), (String)changeMeetingRoomDetailsRequest.getName(), (String)changeMeetingRoomDetailsRequest.getDescription(), (Set)coWorkChannel.getMemberUserIds(), (Set)coWorkChannel.getMemberGroupIds());
        coWorkChannel2.setIcon(coWorkChannel.getIcon());
        String string = changeMeetingRoomDetailsRequest.getIconData();
        if (string == null) {
            coWorkChannel2.setIcon(null);
        } else if (string.startsWith("data:")) {
            try (InputStream inputStream = new URL(string).openStream();){
                coWorkChannel2.setIcon(IOFunctions.readBytes((InputStream)inputStream));
            }
        }
        CoWorkManager.getInstance().saveChannel(coWorkChannel2);
        return null;
    }

    public String getMethodName() {
        return "cowork.meetingrooms.changedetails";
    }

    public short getMethodType() {
        return 1;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Base64 image data will be stored in the model only.")
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ChangeMeetingRoomDetailsRequest)object);
    }
}

