/*
 * Decompiled with CFR 0.152.
 */
package com.inet.calendar.taskplanner.server.series;

import com.inet.annotations.PublicApi;
import com.inet.calendar.CalendarServerPlugin;
import com.inet.calendar.taskplanner.server.series.a;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.FileField;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class CalendarSeriesFactory
extends SeriesFactory<a> {
    public static final String PROPERTY_FILE = "file";

    public CalendarSeriesFactory() {
        super("series.calendar");
    }

    public SeriesInfo getInformation(@Nullable GUID taskID) {
        URL uRL = ((Object)((Object)this)).getClass().getResource("calendar_32.png");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        FileField fileField = new FileField(PROPERTY_FILE, CalendarServerPlugin.MSG.getMsg("series.calendar.file", new Object[0]));
        fileField.setProtocols(this.getAllAvailableProtocols());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("*.ics");
        arrayList2.add("*.cal");
        arrayList2.add("*.*");
        fileField.setFilter(arrayList2);
        arrayList.add(fileField);
        ArrayList<UnitConfigProperty.Unit> arrayList3 = new ArrayList<UnitConfigProperty.Unit>();
        arrayList3.add(new UnitConfigProperty.Unit(0.03571428571428571, CalendarServerPlugin.MSG.getMsg("series.calendar.months", new Object[0])));
        arrayList3.add(new UnitConfigProperty.Unit(0.14285714285714285, CalendarServerPlugin.MSG.getMsg("series.calendar.weeks", new Object[0])));
        arrayList3.add(new UnitConfigProperty.Unit(1.0, CalendarServerPlugin.MSG.getMsg("series.calendar.days", new Object[0])));
        NumberField numberField = new NumberField("from", CalendarServerPlugin.MSG.getMsg("series.calendar.from", new Object[0]), arrayList3);
        arrayList.add(numberField);
        NumberField numberField2 = new NumberField("until", CalendarServerPlugin.MSG.getMsg("series.calendar.until", new Object[0]), arrayList3);
        arrayList.add(numberField2);
        SeriesInfo seriesInfo = new SeriesInfo(this.getExtensionName(), CalendarServerPlugin.MSG.getMsg("series.calendar.displayname", new Object[0]), CalendarServerPlugin.MSG.getMsg("series.calendar.description", new Object[0]), uRL, "taskplanner.series.calendar", arrayList);
        return seriesInfo;
    }

    protected List<String> getAllAvailableProtocols() {
        return FileField.getAllAvailableProtocols();
    }

    public void validate(@Nonnull SeriesDefinition definition, GUID taskID) throws ValidationException {
        String string = definition.getProperty(PROPERTY_FILE);
        String string2 = definition.getProperty("from");
        String string3 = definition.getProperty("until");
        if (string == null || string.isEmpty()) {
            throw new ValidationException(new String[]{CalendarServerPlugin.MSG.getMsg("series.calendar.nofile", new Object[0])});
        }
        if (string2 == null || string2.isEmpty()) {
            throw new ValidationException(new String[]{CalendarServerPlugin.MSG.getMsg("series.calendar.nofrom", new Object[0])});
        }
        if (string3 == null || string3.isEmpty()) {
            throw new ValidationException(new String[]{CalendarServerPlugin.MSG.getMsg("series.calendar.nountil", new Object[0])});
        }
        try {
            new a(taskID, string, Integer.valueOf(string2), Integer.valueOf(string3)).iterator();
        }
        catch (Throwable throwable) {
            ValidationException validationException = new ValidationException(new String[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)});
            validationException.initCause(throwable);
            throw validationException;
        }
    }

    protected a createInstanceFrom(@Nonnull SeriesDefinition definition, @Nullable GUID taskID) {
        Integer n = Integer.valueOf(definition.getProperty("from"));
        Integer n2 = Integer.valueOf(definition.getProperty("until"));
        return new a(taskID, definition.getProperty(PROPERTY_FILE), n, n2);
    }

    public SummaryInfo getSummary(@Nonnull SeriesDefinition definition) {
        Integer n;
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string = definition.getProperty(PROPERTY_FILE);
        String string2 = definition.getProperty("from");
        String string3 = definition.getProperty("until");
        if (string != null && !string.isEmpty()) {
            arrayList.add(new SummaryEntry(null, string));
        }
        if (string2 != null && !string2.isEmpty()) {
            n = Integer.valueOf(string2);
            arrayList.add(new SummaryEntry(null, CalendarServerPlugin.MSG.getMsg("series.calendar.from.description", new Object[]{n, "" + Math.abs(n)})));
        }
        if (string3 != null && !string3.isEmpty()) {
            n = Integer.valueOf(string3);
            arrayList.add(new SummaryEntry(null, CalendarServerPlugin.MSG.getMsg("series.calendar.until.description", new Object[]{n, "" + Math.abs(n)})));
        }
        return new SummaryInfo(arrayList);
    }

    public boolean isAvailable() {
        return true;
    }

    @Nonnull
    public Set<String> getKeys(@Nonnull SeriesDefinition definition) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("calendar.event.summary");
        hashSet.add("calendar.event.description");
        hashSet.add("calendar.event.comments");
        hashSet.add("calendar.event.creationDate");
        hashSet.add("calendar.event.startDate");
        hashSet.add("calendar.event.endDate");
        hashSet.add("calendar.event.startDatePretty");
        hashSet.add("calendar.event.endDatePretty");
        hashSet.add("calendar.event.organizerName");
        hashSet.add("calendar.event.organizerEmail");
        hashSet.add("calendar.event.priority");
        hashSet.add("calendar.event.attendee");
        return hashSet;
    }
}

